/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore.https;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.NameValuePair;
import org.opentripplanner.utils.tostring.ToStringBuilder;

class HttpsDataSourceMetadata {
    static final String CONTENT_TYPE_APPLICATION_GZIP = "application/gzip";
    static final String CONTENT_TYPE_APPLICATION_ZIP = "application/zip";
    private static final Set<String> HTTP_HEADERS = Set.of("Content-Type", "Content-Length", "Last-Modified");
    private final String contentType;
    private final long contentLength;
    private final long lastModified;

    HttpsDataSourceMetadata(List<Header> headers) {
        this(headers.stream().filter(header -> HTTP_HEADERS.contains(header.getName())).collect(Collectors.toUnmodifiableMap(NameValuePair::getName, NameValuePair::getValue)));
    }

    HttpsDataSourceMetadata(Map<String, String> headers) {
        this.contentType = headers.get("Content-Type");
        this.contentLength = HttpsDataSourceMetadata.parseLong(headers.get("Content-Length"));
        this.lastModified = HttpsDataSourceMetadata.parseDate(headers.get("Last-Modified"));
    }

    String contentType() {
        return this.contentType;
    }

    long contentLength() {
        return this.contentLength;
    }

    long lastModified() {
        return this.lastModified;
    }

    boolean isZipContentType() {
        return CONTENT_TYPE_APPLICATION_ZIP.equalsIgnoreCase(this.contentType());
    }

    boolean isGzipContentType() {
        return CONTENT_TYPE_APPLICATION_GZIP.equalsIgnoreCase(this.contentType());
    }

    private static long parseDate(String lastModifiedHeader) {
        Instant lastModifiedDate;
        if (lastModifiedHeader != null && (lastModifiedDate = DateUtils.parseStandardDate((String)lastModifiedHeader)) != null) {
            return lastModifiedDate.toEpochMilli();
        }
        return -1L;
    }

    private static long parseLong(String header) {
        try {
            return Long.parseLong(header);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addObj("contentType", (Object)this.contentType).addObj("contentLength", (Object)this.contentLength).addObj("lastModified", (Object)this.lastModified).toString();
    }
}

