/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.opentripplanner.datastore.api.CompositeDataSource;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.datastore.api.FileType;
import org.opentripplanner.datastore.base.ByteArrayDataSource;
import org.opentripplanner.datastore.file.TemporaryFileDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipStreamDataSourceDecorator
implements CompositeDataSource {
    private static final int DEFAULT_MAX_ZIP_ENTRY_SIZE_IN_MEMORY = 2000000000;
    private static final Logger LOG = LoggerFactory.getLogger(ZipStreamDataSourceDecorator.class);
    private final DataSource delegate;
    private final int maxZipEntrySizeInMemory;
    private boolean contentLoaded = false;
    private List<DataSource> content = new ArrayList<DataSource>();

    public ZipStreamDataSourceDecorator(DataSource delegate) {
        this(delegate, 2000000000);
    }

    ZipStreamDataSourceDecorator(DataSource delegate, int maxZipEntrySizeInMemory) {
        this.delegate = delegate;
        this.maxZipEntrySizeInMemory = maxZipEntrySizeInMemory;
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public String path() {
        return this.delegate.path();
    }

    @Override
    public URI uri() {
        return URI.create(this.path());
    }

    @Override
    public FileType type() {
        return this.delegate.type();
    }

    @Override
    public long size() {
        return this.delegate.size();
    }

    @Override
    public long lastModified() {
        return this.delegate.lastModified();
    }

    @Override
    public boolean exists() {
        return this.delegate.exists();
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public InputStream asInputStream() {
        throw new UnsupportedOperationException("This datasource type " + String.valueOf((Object)this.type()) + " do not support READING. Can not read from: " + this.path());
    }

    @Override
    public OutputStream asOutputStream() {
        throw new UnsupportedOperationException("This datasource type " + String.valueOf((Object)this.type()) + " do not support WRITING. Can not write to: " + this.path());
    }

    @Override
    public String detailedInfo() {
        return this.delegate.detailedInfo();
    }

    @Override
    public Collection<DataSource> content() {
        this.loadContent();
        return this.content;
    }

    @Override
    public DataSource entry(String name) {
        this.loadContent();
        return this.content.stream().filter(it -> name.equals(it.name())).findFirst().orElse(null);
    }

    @Override
    public void close() {
        if (this.content != null) {
            for (DataSource dataSource : this.content) {
                if (!(dataSource instanceof TemporaryFileDataSource)) continue;
                TemporaryFileDataSource tempDataSource = (TemporaryFileDataSource)dataSource;
                tempDataSource.deleteFile();
            }
        }
        this.content = null;
    }

    public String toString() {
        return this.path();
    }

    private void loadContent() {
        if (this.content == null) {
            throw new NullPointerException("The content is accessed after the zip file is closed: " + this.path());
        }
        if (this.contentLoaded) {
            return;
        }
        this.contentLoaded = true;
        try (ZipInputStream zis = new ZipInputStream(this.delegate.asInputStream());){
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    this.uncompressEntry(zis, entry);
                }
                entry = zis.getNextEntry();
            }
        }
        catch (ZipException ex) {
            throw new RuntimeException("Can not read zip file " + this.path() + ": " + ex.getLocalizedMessage(), ex);
        }
        catch (IOException ie) {
            throw new RuntimeException("Failed to load " + this.path() + ": " + ie.getLocalizedMessage(), ie);
        }
    }

    private void uncompressEntry(ZipInputStream zis, ZipEntry entry) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream(4048);
        long nbCopiedBytes = this.copy(zis, buf, (long)this.maxZipEntrySizeInMemory + 1L);
        byte[] byteArray = buf.toByteArray();
        if (nbCopiedBytes <= (long)this.maxZipEntrySizeInMemory) {
            this.content.add(new ByteArrayDataSource(entry.getName() + " (" + this.path() + ")", entry.getName(), this.type(), byteArray.length, entry.getLastModifiedTime().toMillis(), false).withBytes(byteArray));
        } else {
            LOG.info("The entry {} in the zip datasource {} is larger than 2GB. It will be stored on disk", (Object)entry.getName(), (Object)this.name());
            File tmpFile = Files.createTempFile(null, null, new FileAttribute[0]).toFile();
            try (OutputStream outputStream = Files.newOutputStream(tmpFile.toPath(), new OpenOption[0]);){
                outputStream.write(byteArray);
                zis.transferTo(outputStream);
            }
            this.content.add(new TemporaryFileDataSource(entry.getName(), tmpFile, this.type()));
        }
    }

    private long copy(InputStream inputStream, OutputStream outputStream, long maxLength) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        int bytesToRead = buffer.length;
        long totalRead = 0L;
        while (bytesToRead > 0 && (read = inputStream.read(buffer, 0, bytesToRead)) != -1) {
            outputStream.write(buffer, 0, read);
            bytesToRead = (int)Math.min(maxLength - (totalRead += (long)read), (long)buffer.length);
        }
        return totalRead;
    }
}

