/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore.file;

import java.io.File;
import java.net.URI;
import java.util.Objects;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.datastore.api.FileType;

public abstract class AbstractFileDataSource
implements DataSource {
    final File file;
    final FileType type;

    AbstractFileDataSource(File file, FileType type) {
        this.file = file;
        this.type = type;
    }

    @Override
    public String name() {
        return this.file.getName();
    }

    @Override
    public final String path() {
        return this.file.getPath();
    }

    @Override
    public URI uri() {
        return this.file.toURI();
    }

    @Override
    public final FileType type() {
        return this.type;
    }

    @Override
    public final long size() {
        long value = this.file.length();
        return value != 0L ? value : -1L;
    }

    @Override
    public final long lastModified() {
        long value = this.file.lastModified();
        return value != 0L ? value : -1L;
    }

    @Override
    public final boolean exists() {
        return this.file.exists() && this.file.canRead();
    }

    @Override
    public boolean isWritable() {
        return this.file.getParentFile().exists() && (!this.file.exists() || this.file.canWrite());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.file, this.type});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFileDataSource that = (AbstractFileDataSource)o;
        return this.file.equals(that.file) && this.type == that.type;
    }

    public String toString() {
        return String.valueOf((Object)this.type) + " " + this.path();
    }
}

