/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore.api;

import java.util.EnumSet;

public enum FileType {
    CONFIG("\u2699\ufe0f", "Config file"),
    OSM("\ud83c\udf0d", "OpenStreetMap data"),
    DEM("\ud83c\udfd4", "Elevation data"),
    GTFS("\ud83d\ude8c", "GTFS data"),
    NETEX("\ud83d\ude8c", "NeTEx data"),
    EMISSION("\ud83c\udf3f", "Emission data"),
    GRAPH("\ud83c\udf10", "OTP Graph file"),
    REPORT("\ud83d\udcc8", "Issue report"),
    UNKNOWN("\u2753", "Unknown file");

    private final String icon;
    private final String text;

    private FileType(String icon, String text) {
        this.icon = icon;
        this.text = text;
    }

    public String icon() {
        return this.icon;
    }

    public String text() {
        return this.text;
    }

    public boolean isInputDataSource() {
        return EnumSet.of(GTFS, NETEX, OSM, DEM).contains((Object)this);
    }

    public boolean isOutputDataSource() {
        return EnumSet.of(GRAPH, REPORT).contains((Object)this);
    }

    public boolean isTransit() {
        return EnumSet.of(GTFS, NETEX).contains((Object)this);
    }
}

