/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import org.opentripplanner.datastore.api.FileType;
import org.opentripplanner.utils.text.FileSizeToTextConverter;

public interface DataSource {
    public static final long UNKNOWN = -1L;

    public String name();

    public String path();

    public URI uri();

    public FileType type();

    default public long size() {
        return -1L;
    }

    default public long lastModified() {
        return -1L;
    }

    default public boolean exists() {
        return true;
    }

    default public boolean isWritable() {
        return true;
    }

    default public InputStream asInputStream() {
        throw new UnsupportedOperationException("This datasource type " + this.getClass().getSimpleName() + " do not support READING. Can not read from: " + this.path());
    }

    default public byte[] asBytes() {
        byte[] byArray;
        block8: {
            InputStream is = this.asInputStream();
            try {
                byArray = is.readAllBytes();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read " + this.path() + ": " + e.getLocalizedMessage(), e);
                }
            }
            is.close();
        }
        return byArray;
    }

    default public OutputStream asOutputStream() {
        throw new UnsupportedOperationException("This datasource type " + this.getClass().getSimpleName() + " do not support WRITING. Can not write to: " + this.path());
    }

    default public String detailedInfo() {
        Object info = String.format("%s %s  %s", this.type().icon(), this.name(), this.directory());
        if (this.lastModified() > 0L) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            info = (String)info + "  " + sdf.format(this.lastModified());
        }
        if (this.size() > 0L) {
            info = (String)info + "  " + FileSizeToTextConverter.fileSizeToString((long)this.size());
        }
        return info;
    }

    default public String directory() {
        int endIndex = this.path().length() - (this.name().length() + 1);
        return endIndex <= 0 ? "" : this.path().substring(0, endIndex);
    }
}

