/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.astar.strategy;

import java.util.function.Predicate;
import org.opentripplanner.astar.spi.AStarState;
import org.opentripplanner.astar.spi.SearchTerminationStrategy;

public class MaxCountTerminationStrategy<State extends AStarState<State, ?, ?>>
implements SearchTerminationStrategy<State> {
    private final int maxCount;
    private final Predicate<State> shouldIncreaseCount;
    private int count;

    public MaxCountTerminationStrategy(int maxCount, Predicate<State> shouldIncreaseCount) {
        this.maxCount = maxCount;
        this.shouldIncreaseCount = shouldIncreaseCount;
        this.count = 0;
    }

    @Override
    public boolean shouldSearchTerminate(State current) {
        if (this.shouldIncreaseCount.test(current)) {
            ++this.count;
        }
        return this.count >= this.maxCount;
    }
}

