/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.astar.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.astar.model.GraphPath;
import org.opentripplanner.astar.spi.AStarEdge;
import org.opentripplanner.astar.spi.AStarState;
import org.opentripplanner.astar.spi.AStarVertex;
import org.opentripplanner.astar.spi.DominanceFunction;

public class ShortestPathTree<State extends AStarState<State, Edge, Vertex>, Edge extends AStarEdge<State, Edge, Vertex>, Vertex extends AStarVertex<State, Edge, Vertex>> {
    public final DominanceFunction<State> dominanceFunction;
    private final Map<Vertex, List<State>> stateSets;

    public ShortestPathTree(DominanceFunction<State> dominanceFunction) {
        this.dominanceFunction = dominanceFunction;
        this.stateSets = new IdentityHashMap<Vertex, List<State>>(10000);
    }

    public List<GraphPath<State, Edge, Vertex>> getPaths(Vertex dest) {
        List<State> stateList = this.getStates(dest);
        if (stateList == null) {
            return Collections.emptyList();
        }
        LinkedList<GraphPath<State, Edge, Vertex>> ret = new LinkedList<GraphPath<State, Edge, Vertex>>();
        for (AStarState s : stateList) {
            if (!s.isFinal()) continue;
            ret.add(new GraphPath(s));
        }
        return ret;
    }

    public GraphPath<State, Edge, Vertex> getPath(Vertex dest) {
        State s = this.getState(dest);
        if (s == null) {
            return null;
        }
        return new GraphPath(s);
    }

    public Set<Vertex> getVertices() {
        return this.stateSets.keySet();
    }

    public boolean add(State newState) {
        Object vertex = newState.getVertex();
        List<State> states = this.stateSets.get(vertex);
        if (states == null) {
            states = new ArrayList<State>();
            this.stateSets.put(vertex, states);
            states.add(newState);
            return true;
        }
        Iterator<State> it = states.iterator();
        while (it.hasNext()) {
            AStarState oldState = (AStarState)it.next();
            if (this.dominanceFunction.betterOrEqualAndComparable(oldState, (AStarState)newState)) {
                return false;
            }
            if (!this.dominanceFunction.betterOrEqualAndComparable((AStarState)newState, oldState)) continue;
            it.remove();
        }
        states.add(newState);
        return true;
    }

    public State getState(Vertex dest) {
        Collection states = this.stateSets.get(dest);
        if (states == null) {
            return null;
        }
        AStarState ret = null;
        for (AStarState s : states) {
            if (ret != null && !(s.getWeight() < ret.getWeight()) || !s.isFinal()) continue;
            ret = s;
        }
        return (State)ret;
    }

    public List<State> getStates(Vertex dest) {
        return this.stateSets.get(dest);
    }

    public int getVertexCount() {
        return this.stateSets.keySet().size();
    }

    public boolean visit(State state) {
        boolean ret = false;
        for (AStarState s : this.stateSets.get(state.getVertex())) {
            if (s != state) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public Collection<State> getAllStates() {
        ArrayList<State> allStates = new ArrayList<State>();
        for (List<State> stateSet : this.stateSets.values()) {
            allStates.addAll(stateSet);
        }
        return allStates;
    }

    public String toString() {
        return "ShortestPathTree(" + this.stateSets.size() + " vertices)";
    }
}

