/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.astar.model;

import java.util.LinkedList;
import org.opentripplanner.astar.spi.AStarEdge;
import org.opentripplanner.astar.spi.AStarState;
import org.opentripplanner.astar.spi.AStarVertex;

public class GraphPath<State extends AStarState<State, Edge, Vertex>, Edge extends AStarEdge<State, Edge, Vertex>, Vertex extends AStarVertex<State, Edge, Vertex>> {
    public LinkedList<State> states;
    public LinkedList<Edge> edges;

    public GraphPath(State s) {
        State lastState = s.getRequest().arriveBy() ? s.reverse() : s;
        this.states = new LinkedList();
        this.edges = new LinkedList();
        for (State cur = lastState; cur != null; cur = cur.getBackState()) {
            this.states.addFirst(cur);
            if (cur.getBackEdge() == null || cur.getBackState() == null) continue;
            this.edges.addFirst(cur.getBackEdge());
        }
    }

    public long getStartTime() {
        return ((AStarState)this.states.getFirst()).getTimeSeconds();
    }

    public long getEndTime() {
        return ((AStarState)this.states.getLast()).getTimeSeconds();
    }

    public int getDuration() {
        return (int)((AStarState)this.states.getLast()).getElapsedTimeSeconds();
    }

    public double getWeight() {
        return ((AStarState)this.states.getLast()).getWeight();
    }

    public int hashCode() {
        return this.edges.hashCode();
    }

    public boolean equals(Object o) {
        return false;
    }

    public String toString() {
        return "GraphPath(nStates=" + this.states.size() + ")";
    }
}

