/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.astar;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.opentripplanner.astar.AStar;
import org.opentripplanner.astar.model.GraphPath;
import org.opentripplanner.astar.model.ShortestPathTree;
import org.opentripplanner.astar.spi.AStarEdge;
import org.opentripplanner.astar.spi.AStarState;
import org.opentripplanner.astar.spi.AStarVertex;
import org.opentripplanner.astar.spi.DominanceFunction;
import org.opentripplanner.astar.spi.RemainingWeightHeuristic;
import org.opentripplanner.astar.spi.SearchTerminationStrategy;
import org.opentripplanner.astar.spi.SkipEdgeStrategy;
import org.opentripplanner.astar.spi.TraverseVisitor;

public abstract class AStarBuilder<State extends AStarState<State, Edge, Vertex>, Edge extends AStarEdge<State, Edge, Vertex>, Vertex extends AStarVertex<State, Edge, Vertex>, Builder extends AStarBuilder<State, Edge, Vertex, Builder>> {
    private Builder builder;
    private RemainingWeightHeuristic<State> heuristic = RemainingWeightHeuristic.TRIVIAL;
    private SkipEdgeStrategy<State, Edge> skipEdgeStrategy;
    private TraverseVisitor<State, Edge> traverseVisitor;
    private boolean arriveBy;
    private Set<Vertex> fromVertices;
    private Set<Vertex> toVertices;
    private SearchTerminationStrategy<State> terminationStrategy;
    private DominanceFunction<State> dominanceFunction;
    private Edge originBackEdge;
    private Collection<State> initialStates;

    protected AStarBuilder() {
    }

    protected void setBuilder(Builder builder) {
        this.builder = builder;
    }

    public Builder setHeuristic(RemainingWeightHeuristic<State> heuristic) {
        this.heuristic = heuristic;
        return this.builder;
    }

    public Builder setSkipEdgeStrategy(SkipEdgeStrategy<State, Edge> skipEdgeStrategy) {
        this.skipEdgeStrategy = skipEdgeStrategy;
        return this.builder;
    }

    public Builder setTraverseVisitor(TraverseVisitor<State, Edge> traverseVisitor) {
        this.traverseVisitor = traverseVisitor;
        return this.builder;
    }

    public Builder setArriveBy(boolean arriveBy) {
        this.arriveBy = arriveBy;
        return this.builder;
    }

    protected boolean arriveBy() {
        return this.arriveBy;
    }

    public Builder setFrom(Set<Vertex> fromVertices) {
        this.fromVertices = fromVertices;
        return this.builder;
    }

    public Builder setFrom(Vertex fromVertex) {
        this.fromVertices = Collections.singleton(fromVertex);
        return this.builder;
    }

    public Builder setTo(Set<Vertex> toVertices) {
        this.toVertices = toVertices;
        return this.builder;
    }

    public Builder setTo(Vertex toVertex) {
        this.toVertices = Collections.singleton(toVertex);
        return this.builder;
    }

    public Builder setTerminationStrategy(SearchTerminationStrategy<State> terminationStrategy) {
        this.terminationStrategy = terminationStrategy;
        return this.builder;
    }

    public Builder setDominanceFunction(DominanceFunction<State> dominanceFunction) {
        this.dominanceFunction = dominanceFunction;
        return this.builder;
    }

    protected abstract Duration streetRoutingTimeout();

    public Builder setOriginBackEdge(Edge originBackEdge) {
        this.originBackEdge = originBackEdge;
        return this.builder;
    }

    public Builder setInitialStates(Collection<State> initialStates) {
        this.initialStates = initialStates;
        return this.builder;
    }

    public ShortestPathTree<State, Edge, Vertex> getShortestPathTree() {
        return this.build().getShortestPathTree();
    }

    public List<GraphPath<State, Edge, Vertex>> getPathsToTarget() {
        return this.build().getPathsToTarget();
    }

    private AStar<State, Edge, Vertex> build() {
        Collection<State> initialStates;
        Set<Vertex> destination;
        Set<Vertex> origin = this.arriveBy ? this.toVertices : this.fromVertices;
        Set<Vertex> set = destination = this.arriveBy ? this.fromVertices : this.toVertices;
        if (this.initialStates != null) {
            initialStates = this.initialStates;
        } else {
            initialStates = this.createInitialStates(origin);
            if (this.originBackEdge != null) {
                for (AStarState state : initialStates) {
                    state.initBackEdge(this.originBackEdge);
                }
            }
        }
        this.prepareInitialStates(initialStates);
        this.initializeHeuristic(this.heuristic, origin, destination, this.arriveBy);
        return new AStar<State, Edge, Vertex>(this.heuristic, this.skipEdgeStrategy, this.traverseVisitor, this.arriveBy, origin, destination, this.terminationStrategy, Optional.ofNullable(this.dominanceFunction).orElseGet(this::createDefaultDominanceFunction), this.streetRoutingTimeout(), initialStates);
    }

    protected abstract Collection<State> createInitialStates(Set<Vertex> var1);

    protected abstract void prepareInitialStates(Collection<State> var1);

    protected abstract void initializeHeuristic(RemainingWeightHeuristic<State> var1, Set<Vertex> var2, Set<Vertex> var3, boolean var4);

    protected abstract DominanceFunction<State> createDefaultDominanceFunction();
}

