/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.astar;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.astar.model.BinHeap;
import org.opentripplanner.astar.model.GraphPath;
import org.opentripplanner.astar.model.ShortestPathTree;
import org.opentripplanner.astar.spi.AStarEdge;
import org.opentripplanner.astar.spi.AStarState;
import org.opentripplanner.astar.spi.AStarVertex;
import org.opentripplanner.astar.spi.DominanceFunction;
import org.opentripplanner.astar.spi.RemainingWeightHeuristic;
import org.opentripplanner.astar.spi.SearchTerminationStrategy;
import org.opentripplanner.astar.spi.SkipEdgeStrategy;
import org.opentripplanner.astar.spi.TraverseVisitor;
import org.opentripplanner.framework.application.OTPRequestTimeoutException;
import org.opentripplanner.utils.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AStar<State extends AStarState<State, Edge, Vertex>, Edge extends AStarEdge<State, Edge, Vertex>, Vertex extends AStarVertex<State, Edge, Vertex>> {
    private static final Logger LOG = LoggerFactory.getLogger(AStar.class);
    private static final boolean verbose = LOG.isDebugEnabled();
    private final boolean arriveBy;
    private final Set<Vertex> fromVertices;
    private final Set<Vertex> toVertices;
    private final RemainingWeightHeuristic<State> heuristic;
    private final SkipEdgeStrategy<State, Edge> skipEdgeStrategy;
    private final SearchTerminationStrategy<State> terminationStrategy;
    private final TraverseVisitor<State, Edge> traverseVisitor;
    private final Duration timeout;
    private final ShortestPathTree<State, Edge, Vertex> spt;
    private final BinHeap<State> pq;
    private final List<State> targetAcceptedStates;
    private State u;
    private int nVisited;

    AStar(RemainingWeightHeuristic<State> heuristic, SkipEdgeStrategy<State, Edge> skipEdgeStrategy, TraverseVisitor<State, Edge> traverseVisitor, boolean arriveBy, Set<Vertex> fromVertices, Set<Vertex> toVertices, SearchTerminationStrategy<State> terminationStrategy, DominanceFunction<State> dominanceFunction, Duration timeout, Collection<State> initialStates) {
        this.heuristic = heuristic;
        this.skipEdgeStrategy = skipEdgeStrategy;
        this.traverseVisitor = traverseVisitor;
        this.fromVertices = fromVertices;
        this.toVertices = toVertices;
        this.arriveBy = arriveBy;
        this.terminationStrategy = terminationStrategy;
        this.timeout = Objects.requireNonNull(timeout);
        this.spt = new ShortestPathTree(dominanceFunction);
        this.pq = new BinHeap(1000);
        this.nVisited = 0;
        this.targetAcceptedStates = new ArrayList<State>();
        for (AStarState initialState : initialStates) {
            this.spt.add(initialState);
            this.pq.insert(initialState, initialState.getWeight());
        }
    }

    ShortestPathTree<State, Edge, Vertex> getShortestPathTree() {
        this.runSearch();
        return this.spt;
    }

    List<GraphPath<State, Edge, Vertex>> getPathsToTarget() {
        this.runSearch();
        return this.targetAcceptedStates.stream().filter(AStarState::isFinal).map(GraphPath::new).collect(Collectors.toList());
    }

    private boolean iterate() {
        if (verbose) {
            double w = this.pq.peek_min_key();
            LOG.debug("pq min key = {}", (Object)w);
        }
        this.u = (AStarState)this.pq.extract_min();
        if (!this.spt.visit(this.u)) {
            return false;
        }
        if (this.traverseVisitor != null) {
            this.traverseVisitor.visitVertex(this.u);
        }
        ++this.nVisited;
        Object u_vertex = this.u.getVertex();
        if (verbose) {
            LOG.debug("   vertex {}", u_vertex);
        }
        Collection edges = this.arriveBy ? u_vertex.getIncoming() : u_vertex.getOutgoing();
        for (AStarEdge edge : edges) {
            AStarState[] states;
            if (this.skipEdgeStrategy != null && this.skipEdgeStrategy.shouldSkipEdge(this.u, edge)) continue;
            for (AStarState v : states = edge.traverse((AStarState)this.u)) {
                double remaining_w;
                if (this.traverseVisitor != null) {
                    this.traverseVisitor.visitEdge(edge);
                }
                if ((remaining_w = this.heuristic.estimateRemainingWeight(v)) < 0.0 || Double.isInfinite(remaining_w)) continue;
                double estimate = v.getWeight() + remaining_w;
                if (verbose) {
                    LOG.debug("      edge {}", (Object)edge);
                    LOG.debug("      {} -> {}(w) + {}(heur) = {} vert = {}", new Object[]{this.u.getWeight(), v.getWeight(), remaining_w, estimate, v.getVertex()});
                }
                if (!this.spt.add(v)) continue;
                if (this.traverseVisitor != null) {
                    this.traverseVisitor.visitEnqueue();
                }
                this.pq.insert(v, estimate);
            }
        }
        return true;
    }

    private void runSearch() {
        OTPRequestTimeoutException.checkForTimeout();
        long abortTime = DateUtils.absoluteTimeout((Duration)this.timeout);
        while (!this.pq.empty()) {
            if (this.timeout != null && this.nVisited % 100 == 0 && System.currentTimeMillis() > abortTime) {
                LOG.warn("Search timeout. origin={} target={}", this.fromVertices, this.toVertices);
                break;
            }
            if (!this.iterate()) continue;
            if (this.terminationStrategy != null && this.terminationStrategy.shouldSearchTerminate(this.u)) break;
            if (this.toVertices == null || !this.toVertices.contains(this.u.getVertex()) || !this.u.isFinal()) continue;
            this.targetAcceptedStates.add(this.u);
            LOG.debug("total vertices visited {}", (Object)this.nVisited);
            break;
        }
    }
}

