/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.vectortiles.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import org.opentripplanner.utils.lang.StringUtils;

public sealed interface TileSource {
    @JsonSerialize
    public String type();

    public String id();

    public String name();

    public record RasterSource(String name, List<String> tiles, int maxzoom, int tileSize, String attribution) implements TileSource
    {
        @Override
        public String type() {
            return "raster";
        }

        @Override
        public String id() {
            return StringUtils.slugify((String)this.name);
        }
    }

    public record VectorSource(String id, String url) implements TileSource
    {
        @Override
        public String type() {
            return "vector";
        }

        @Override
        public String name() {
            return this.id;
        }
    }
}

