/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.vectortiles.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opentripplanner.apis.vectortiles.model.StyleBuilder;
import org.opentripplanner.apis.vectortiles.model.TileSource;

public final class StyleSpec {
    private final String name;
    private final Collection<TileSource> sources;
    private final List<JsonNode> layers;

    public StyleSpec(String name, Collection<TileSource> sources, List<StyleBuilder> layers) {
        this.name = name;
        this.sources = sources;
        this.layers = layers.stream().map(StyleBuilder::toJson).toList();
    }

    @JsonSerialize
    public int version() {
        return 8;
    }

    @JsonSerialize
    public String name() {
        return this.name;
    }

    @JsonSerialize
    public Map<String, TileSource> sources() {
        HashMap<String, TileSource> output = new HashMap<String, TileSource>();
        this.sources.forEach(s -> output.put(s.id(), (TileSource)s));
        return output;
    }

    @JsonSerialize
    public List<JsonNode> layers() {
        return this.layers;
    }

    @JsonSerialize
    public String glyphs() {
        return "https://cdn.jsdelivr.net/gh/klokantech/klokantech-gl-fonts@master/{fontstack}/{range}.pbf";
    }
}

