/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.vectortiles.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.opentripplanner.apis.vectortiles.model.TileSource;
import org.opentripplanner.apis.vectortiles.model.VectorSourceLayer;
import org.opentripplanner.apis.vectortiles.model.ZoomDependentNumber;
import org.opentripplanner.framework.json.ObjectMappers;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.utils.collection.ListUtils;
import org.opentripplanner.utils.lang.DoubleUtils;

public class StyleBuilder {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMappers.ignoringExtraFields();
    private static final String TYPE = "type";
    private static final String SOURCE_LAYER = "source-layer";
    private final Map<String, Object> props = new LinkedHashMap<String, Object>();
    private final Map<String, Object> paint = new LinkedHashMap<String, Object>();
    private final Map<String, Object> layout = new LinkedHashMap<String, Object>();
    private final Map<String, Object> metadata = new LinkedHashMap<String, Object>();
    private final Map<String, Object> line = new LinkedHashMap<String, Object>();
    private List<?> filter = List.of();

    public static StyleBuilder ofId(String id) {
        return new StyleBuilder(id);
    }

    public StyleBuilder vectorSourceLayer(VectorSourceLayer source) {
        this.source(source.vectorSource());
        return this.sourceLayer(source.vectorLayer());
    }

    private StyleBuilder(String id) {
        this.props.put("id", id);
        this.metadata.put("group", "Other");
    }

    public StyleBuilder minZoom(int i) {
        this.props.put("minzoom", i);
        return this;
    }

    public StyleBuilder maxZoom(int i) {
        this.props.put("maxzoom", i);
        return this;
    }

    public StyleBuilder source(TileSource source) {
        this.props.put("source", source.id());
        return this;
    }

    public StyleBuilder sourceLayer(String source) {
        this.props.put(SOURCE_LAYER, source);
        return this;
    }

    public StyleBuilder typeRaster() {
        return this.type(LayerType.Raster);
    }

    public StyleBuilder typeCircle() {
        return this.type(LayerType.Circle);
    }

    public StyleBuilder typeLine() {
        this.type(LayerType.Line);
        this.layout.put("line-cap", "round");
        return this;
    }

    public StyleBuilder typeFill() {
        this.type(LayerType.Fill);
        return this;
    }

    public StyleBuilder typeSymbol() {
        this.type(LayerType.Symbol);
        return this;
    }

    private StyleBuilder type(LayerType type) {
        this.props.put(TYPE, type.name().toLowerCase());
        return this;
    }

    public StyleBuilder group(String group) {
        this.metadata.put("group", group);
        return this;
    }

    public StyleBuilder displayName(String name) {
        this.metadata.put("name", name);
        return this;
    }

    public StyleBuilder symbolText(String name) {
        this.layout.put("text-field", "{%s}".formatted(name));
        this.layout.put("text-font", List.of("KlokanTech Noto Sans Regular"));
        this.layout.put("text-size", new ZoomDependentNumber(List.of(new ZoomDependentNumber.ZoomStop(10, 6.0f), new ZoomDependentNumber.ZoomStop(24, 12.0f))).toJson());
        this.layout.put("text-max-width", 100);
        this.layout.put("text-keep-upright", true);
        this.layout.put("text-rotation-alignment", "map");
        this.layout.put("text-overlap", "never");
        this.paint.put("text-color", "#000");
        this.paint.put("text-halo-color", "#fff");
        this.paint.put("text-halo-blur", 4);
        this.paint.put("text-halo-width", 3);
        return this;
    }

    public StyleBuilder lineText(String name) {
        this.layout.put("symbol-placement", "line-center");
        this.layout.put("symbol-spacing", 1000);
        return this.symbolText(name);
    }

    public StyleBuilder textOffset(float offset) {
        this.layout.put("text-offset", List.of(Integer.valueOf(0), Float.valueOf(offset)));
        return this;
    }

    public StyleBuilder circleColor(String color) {
        this.paint.put("circle-color", this.validateColor(color));
        return this;
    }

    public StyleBuilder circleStroke(String color, ZoomDependentNumber width) {
        this.paint.put("circle-stroke-color", this.validateColor(color));
        this.paint.put("circle-stroke-width", width.toJson());
        return this;
    }

    public StyleBuilder circleRadius(ZoomDependentNumber radius) {
        this.paint.put("circle-radius", radius.toJson());
        return this;
    }

    public StyleBuilder lineCap(String lineCap) {
        this.layout.put("line-cap", lineCap);
        return this;
    }

    public StyleBuilder lineColor(String color) {
        this.paint.put("line-color", this.validateColor(color));
        return this;
    }

    public StyleBuilder lineColorFromProperty(String propertyName, double minValue, double maxValue) {
        List<Object> multiplier = List.of("*", Double.valueOf(DoubleUtils.roundTo2Decimals((double)(255.0 / (maxValue - minValue)))), List.of("get", propertyName));
        this.setLineColor(multiplier);
        return this;
    }

    public StyleBuilder log2LineColorFromProperty(String propertyName, double logMultiplier) {
        List<Object> multiplier = List.of("*", Double.valueOf(logMultiplier), List.of("log2", List.of("get", propertyName)));
        this.setLineColor(multiplier);
        return this;
    }

    public StyleBuilder lineColorMatch(String propertyName, Collection<String> values, String defaultValue) {
        this.paint.put("line-color", ListUtils.combine((Collection[])new Collection[]{List.of("match", List.of("get", propertyName)), values, List.of(defaultValue)}));
        return this;
    }

    public StyleBuilder lineWidth(ZoomDependentNumber zoomStops) {
        this.paint.put("line-width", zoomStops.toJson());
        return this;
    }

    public StyleBuilder lineOffset(ZoomDependentNumber zoomStops) {
        this.paint.put("line-offset", zoomStops.toJson());
        return this;
    }

    public StyleBuilder fillColor(String color) {
        this.paint.put("fill-color", this.validateColor(color));
        return this;
    }

    public StyleBuilder fillOpacity(float opacity) {
        this.paint.put("fill-opacity", Float.valueOf(opacity));
        return this;
    }

    public StyleBuilder fillOutlineColor(String color) {
        this.paint.put("fill-outline-color", this.validateColor(color));
        return this;
    }

    public StyleBuilder intiallyHidden() {
        this.layout.put("visibility", "none");
        return this;
    }

    @SafeVarargs
    public final StyleBuilder edgeFilter(Class<? extends Edge> ... classToFilter) {
        return this.filterClasses(classToFilter);
    }

    public final StyleBuilder booleanFilter(String propertyName, boolean value) {
        this.filter = List.of("==", propertyName, Boolean.valueOf(value));
        return this;
    }

    @SafeVarargs
    public final StyleBuilder vertexFilter(Class<? extends Vertex> ... classToFilter) {
        return this.filterClasses(classToFilter);
    }

    @SafeVarargs
    public final StyleBuilder classFilter(Class<?> ... classToFilter) {
        return this.filterClasses(classToFilter);
    }

    public StyleBuilder filterValueInProperty(String propertyName, String ... values) {
        ArrayList newFilter = new ArrayList();
        newFilter.add("any");
        for (String value : values) {
            newFilter.add(List.of("in", value, List.of("string", List.of("get", propertyName))));
        }
        this.filter = newFilter;
        return this;
    }

    public JsonNode toJson() {
        this.validate();
        LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(this.props);
        if (!this.paint.isEmpty()) {
            copy.put("paint", this.paint);
        }
        if (!this.filter.isEmpty()) {
            copy.put("filter", this.filter);
        }
        if (!this.layout.isEmpty()) {
            copy.put("layout", this.layout);
        }
        if (!this.line.isEmpty()) {
            copy.put("line", this.line);
        }
        copy.put("metadata", this.metadata);
        return OBJECT_MAPPER.valueToTree(copy);
    }

    private StyleBuilder filterClasses(Class ... classToFilter) {
        List<String> clazzes = Arrays.stream(classToFilter).map(Class::getSimpleName).toList();
        this.filter = new ArrayList(ListUtils.combine((Collection[])new Collection[]{List.of("in", "class"), clazzes}));
        return this;
    }

    private String validateColor(String color) {
        if (!color.startsWith("#")) {
            throw new IllegalArgumentException("Colors must start with '#'");
        }
        return color;
    }

    private void validate() {
        Stream.of(TYPE).forEach(p -> Objects.requireNonNull(this.props.get(p), "%s must be set".formatted(p)));
    }

    private void setLineColor(List<Object> valueSpecifier) {
        this.paint.put("line-color", List.of("rgb", List.of("min", Integer.valueOf(255), valueSpecifier), List.of("max", Integer.valueOf(0), List.of("-", Integer.valueOf(255), valueSpecifier)), Integer.valueOf(60)));
    }

    public static enum LayerType {
        Circle,
        Line,
        Raster,
        Fill,
        Symbol;

    }
}

