/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.vectortiles;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.glassfish.grizzly.http.server.Request;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.apis.support.TileJson;
import org.opentripplanner.apis.vectortiles.DebugStyleSpec;
import org.opentripplanner.apis.vectortiles.model.LayerParams;
import org.opentripplanner.apis.vectortiles.model.LayerType;
import org.opentripplanner.apis.vectortiles.model.StyleSpec;
import org.opentripplanner.apis.vectortiles.model.TileSource;
import org.opentripplanner.framework.io.HttpUtils;
import org.opentripplanner.inspector.vector.LayerBuilder;
import org.opentripplanner.inspector.vector.LayerParameters;
import org.opentripplanner.inspector.vector.VectorTileResponseFactory;
import org.opentripplanner.inspector.vector.edge.EdgeLayerBuilder;
import org.opentripplanner.inspector.vector.geofencing.GeofencingZonesLayerBuilder;
import org.opentripplanner.inspector.vector.rental.RentalLayerBuilder;
import org.opentripplanner.inspector.vector.stop.GroupStopLayerBuilder;
import org.opentripplanner.inspector.vector.stop.StopLayerBuilder;
import org.opentripplanner.inspector.vector.vertex.VertexLayerBuilder;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.service.worldenvelope.model.WorldEnvelope;
import org.opentripplanner.standalone.api.OtpServerRequestContext;

@Path(value="/debug/vectortiles")
public class DebugVectorTilesResource {
    private static final LayerParams REGULAR_STOPS = new LayerParams("regularStops", LayerType.RegularStop);
    private static final LayerParams AREA_STOPS = new LayerParams("areaStops", LayerType.AreaStop);
    private static final LayerParams GROUP_STOPS = new LayerParams("groupStops", LayerType.GroupStop);
    private static final LayerParams GEOFENCING_ZONES = new LayerParams("geofencingZones", LayerType.GeofencingZones);
    private static final LayerParams EDGES = new LayerParams("edges", LayerType.Edge);
    private static final LayerParams VERTICES = new LayerParams("vertices", LayerType.Vertex);
    private static final LayerParams RENTAL = new LayerParams("rental", LayerType.Rental);
    private static final List<LayerParameters<LayerType>> DEBUG_LAYERS = List.of(REGULAR_STOPS, AREA_STOPS, GROUP_STOPS, GEOFENCING_ZONES, EDGES, VERTICES, RENTAL);
    public static final String PATH = "/otp/debug/vectortiles/";
    private final OtpServerRequestContext serverContext;

    public DebugVectorTilesResource(@Context OtpServerRequestContext serverContext) {
        this.serverContext = serverContext;
    }

    @GET
    @Path(value="/{layers}/{z}/{x}/{y}.pbf")
    @Produces(value={"application/x-protobuf"})
    public Response tileGet(@Context Request grizzlyRequest, @PathParam(value="x") int x, @PathParam(value="y") int y, @PathParam(value="z") int z, @PathParam(value="layers") String requestedLayers) {
        return VectorTileResponseFactory.create(x, y, z, grizzlyRequest.getLocale(), Arrays.asList(requestedLayers.split(",")), DEBUG_LAYERS, DebugVectorTilesResource::createLayerBuilder, this.serverContext);
    }

    @GET
    @Path(value="/{layers}/tilejson.json")
    @Produces(value={"application/json"})
    public TileJson getTileJson(@Context UriInfo uri, @Context HttpHeaders headers, @PathParam(value="layers") String requestedLayers) {
        WorldEnvelope envelope = this.serverContext.worldEnvelopeService().envelope().orElseThrow();
        List<FeedInfo> feedInfos = this.feedInfos();
        List<String> layers = Arrays.asList(requestedLayers.split(","));
        String url = TileJson.urlFromOverriddenBasePath(uri, headers, PATH, layers);
        return new TileJson(url, envelope, feedInfos, 9, 20);
    }

    @GET
    @Path(value="/style.json")
    @Produces(value={"application/json"})
    public StyleSpec getTileJson(@Context UriInfo uri, @Context HttpHeaders headers) {
        String base = HttpUtils.getBaseAddress(uri, headers);
        TileSource.VectorSource stopsSource = new TileSource.VectorSource("stops", DebugVectorTilesResource.tileJsonUrl(base, List.of(REGULAR_STOPS, AREA_STOPS, GROUP_STOPS)));
        TileSource.VectorSource streetSource = new TileSource.VectorSource("street", DebugVectorTilesResource.tileJsonUrl(base, List.of(EDGES, GEOFENCING_ZONES, VERTICES)));
        TileSource.VectorSource rentalSource = new TileSource.VectorSource("rental", DebugVectorTilesResource.tileJsonUrl(base, List.of(RENTAL)));
        return DebugStyleSpec.build(REGULAR_STOPS.toVectorSourceLayer(stopsSource), AREA_STOPS.toVectorSourceLayer(stopsSource), GROUP_STOPS.toVectorSourceLayer(stopsSource), EDGES.toVectorSourceLayer(streetSource), VERTICES.toVectorSourceLayer(streetSource), RENTAL.toVectorSourceLayer(rentalSource), this.serverContext.debugUiConfig().additionalBackgroundLayers());
    }

    static String tileJsonUrl(String base, List<LayerParameters<LayerType>> layers) {
        String allLayers = layers.stream().map(LayerParameters::name).collect(Collectors.joining(","));
        return "%s%s%s/tilejson.json".formatted(base, PATH, allLayers);
    }

    private List<FeedInfo> feedInfos() {
        return this.serverContext.transitService().listFeedIds().stream().map(this.serverContext.transitService()::getFeedInfo).filter(Predicate.not(Objects::isNull)).toList();
    }

    private static LayerBuilder<?> createLayerBuilder(LayerParameters<LayerType> layerParameters, Locale locale, OtpServerRequestContext context) {
        return switch (layerParameters.type()) {
            default -> throw new MatchException(null, null);
            case LayerType.RegularStop -> new StopLayerBuilder(layerParameters, locale, e -> context.transitService().findRegularStopsByBoundingBox((Envelope)e));
            case LayerType.AreaStop -> new StopLayerBuilder(layerParameters, locale, e -> context.transitService().findAreaStops((Envelope)e));
            case LayerType.GroupStop -> new GroupStopLayerBuilder(layerParameters, locale, context.transitService().listGroupStops());
            case LayerType.GeofencingZones -> new GeofencingZonesLayerBuilder(context.graph(), layerParameters);
            case LayerType.Edge -> new EdgeLayerBuilder(context.graph(), layerParameters);
            case LayerType.Vertex -> new VertexLayerBuilder(context.graph(), layerParameters);
            case LayerType.Rental -> new RentalLayerBuilder(context.vehicleRentalService(), layerParameters);
        };
    }
}

