/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.vectortiles;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.opentripplanner.apis.vectortiles.model.StyleBuilder;
import org.opentripplanner.apis.vectortiles.model.StyleSpec;
import org.opentripplanner.apis.vectortiles.model.TileSource;
import org.opentripplanner.apis.vectortiles.model.VectorSourceLayer;
import org.opentripplanner.apis.vectortiles.model.ZoomDependentNumber;
import org.opentripplanner.inspector.vector.edge.EdgePropertyMapper;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalStation;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalVehicle;
import org.opentripplanner.service.vehiclerental.street.StreetVehicleRentalLink;
import org.opentripplanner.standalone.config.debuguiconfig.BackgroundTileLayer;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.edge.AreaEdge;
import org.opentripplanner.street.model.edge.BoardingLocationToStopLink;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.ElevatorHopEdge;
import org.opentripplanner.street.model.edge.EscalatorEdge;
import org.opentripplanner.street.model.edge.PathwayEdge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.edge.StreetStationCentroidLink;
import org.opentripplanner.street.model.edge.StreetTransitEntranceLink;
import org.opentripplanner.street.model.edge.StreetTransitStopLink;
import org.opentripplanner.street.model.edge.StreetVehicleParkingLink;
import org.opentripplanner.street.model.edge.TemporaryFreeEdge;
import org.opentripplanner.street.model.edge.TemporaryPartialStreetEdge;
import org.opentripplanner.street.model.vertex.VehicleParkingEntranceVertex;
import org.opentripplanner.utils.collection.ListUtils;

public class DebugStyleSpec {
    private static final TileSource OSM_BACKGROUND = new TileSource.RasterSource("OSM Carto", List.of("https://a.tile.openstreetmap.org/{z}/{x}/{y}.png"), 19, 256, "\u00a9 OpenStreetMap Contributors");
    private static final TileSource POSITRON_BACKGROUND = new TileSource.RasterSource("Positron", List.of("https://cartodb-basemaps-a.global.ssl.fastly.net/light_all/{z}/{x}/{y}{ratio}.png"), 19, 256, "\u00a9 <a href=\"http://www.openstreetmap.org/copyright\">OpenStreetMap</a>, &copy; <a href=\"https://carto.com/attributions\">CARTO</a>");
    private static final List<TileSource> BACKGROUND_LAYERS = List.of(OSM_BACKGROUND, POSITRON_BACKGROUND);
    private static final String MAGENTA = "#f21d52";
    private static final String BRIGHT_GREEN = "#22DD9E";
    private static final String DARK_GREEN = "#136b04";
    private static final String TEAL = "#277eb5";
    private static final String TURQUOISE = "#1cafad";
    private static final String RED = "#fc0f2a";
    private static final String PURPLE = "#BC55F2";
    private static final String BLACK = "#140d0e";
    private static final int MAX_ZOOM = 23;
    private static final ZoomDependentNumber LARGE_CIRCLE_LINE_WIDTH = new ZoomDependentNumber(List.of(new ZoomDependentNumber.ZoomStop(11, 0.5f), new ZoomDependentNumber.ZoomStop(23, 5.0f)));
    private static final ZoomDependentNumber LARGE_CIRCLE_RADIUS = new ZoomDependentNumber(List.of(new ZoomDependentNumber.ZoomStop(11, 0.5f), new ZoomDependentNumber.ZoomStop(23, 10.0f)));
    private static final ZoomDependentNumber MEDIUM_CIRCLE_RADIUS = new ZoomDependentNumber(List.of(new ZoomDependentNumber.ZoomStop(13, 1.4f), new ZoomDependentNumber.ZoomStop(23, 10.0f)));
    private static final int LINE_DETAIL_ZOOM = 13;
    private static final ZoomDependentNumber LINE_OFFSET = new ZoomDependentNumber(List.of(new ZoomDependentNumber.ZoomStop(13, 0.4f), new ZoomDependentNumber.ZoomStop(23, 7.0f)));
    private static final ZoomDependentNumber LINE_WIDTH = new ZoomDependentNumber(List.of(new ZoomDependentNumber.ZoomStop(13, 0.2f), new ZoomDependentNumber.ZoomStop(23, 8.0f)));
    private static final ZoomDependentNumber LINE_HALF_WIDTH = new ZoomDependentNumber(List.of(new ZoomDependentNumber.ZoomStop(13, 0.1f), new ZoomDependentNumber.ZoomStop(23, 6.0f)));
    private static final ZoomDependentNumber CIRCLE_STROKE = new ZoomDependentNumber(List.of(new ZoomDependentNumber.ZoomStop(15, 0.2f), new ZoomDependentNumber.ZoomStop(23, 3.0f)));
    private static final Class<Edge>[] EDGES_TO_DISPLAY = new Class[]{StreetEdge.class, AreaEdge.class, EscalatorEdge.class, PathwayEdge.class, ElevatorHopEdge.class, TemporaryPartialStreetEdge.class, TemporaryFreeEdge.class};
    private static final String EDGES_GROUP = "Edges";
    private static final String ELEVATION_GROUP = "Elevation";
    private static final String WALK_SAFETY_GROUP = "Walk safety";
    private static final String BICYCLE_SAFETY_GROUP = "Bicycle safety";
    private static final String STOPS_GROUP = "Stops";
    private static final String VERTICES_GROUP = "Vertices";
    private static final String RENTAL_GROUP = "Rental";
    private static final String PERMISSIONS_GROUP = "Permissions";
    private static final String NO_THRU_TRAFFIC_GROUP = "No-thru traffic";
    private static final StreetTraversalPermission[] streetModes = new StreetTraversalPermission[]{StreetTraversalPermission.PEDESTRIAN, StreetTraversalPermission.BICYCLE, StreetTraversalPermission.CAR};
    private static final String WHEELCHAIR_GROUP = "Wheelchair accessibility";

    static StyleSpec build(VectorSourceLayer regularStops, VectorSourceLayer areaStops, VectorSourceLayer groupStops, VectorSourceLayer edges, VectorSourceLayer vertices, VectorSourceLayer rental, List<BackgroundTileLayer> extraLayers) {
        List<TileSource> vectorSources = Stream.of(regularStops, edges, vertices, rental).map(VectorSourceLayer::vectorSource).map(TileSource.class::cast).toList();
        List<TileSource> extraRasterSources = extraLayers.stream().map(l -> new TileSource.RasterSource(l.name(), List.of(l.templateUrl()), 19, l.tileSize(), l.attribution())).toList();
        List allSources = ListUtils.combine((Collection[])new Collection[]{BACKGROUND_LAYERS, extraRasterSources, vectorSources});
        return new StyleSpec("OTP Debug Tiles", allSources, ListUtils.combine((Collection[])new Collection[]{DebugStyleSpec.backgroundLayers(extraRasterSources), DebugStyleSpec.rental(rental), DebugStyleSpec.wheelchair(edges), DebugStyleSpec.noThruTraffic(edges), DebugStyleSpec.bicycleSafety(edges), DebugStyleSpec.walkSafety(edges), DebugStyleSpec.traversalPermissions(edges), DebugStyleSpec.edges(edges), DebugStyleSpec.elevation(edges, vertices), DebugStyleSpec.vertices(vertices), DebugStyleSpec.stops(regularStops, areaStops, groupStops)}));
    }

    private static List<StyleBuilder> backgroundLayers(List<TileSource> extraLayers) {
        return ListUtils.combine((Collection[])new Collection[]{BACKGROUND_LAYERS, extraLayers}).stream().map(layer -> {
            StyleBuilder builder = StyleBuilder.ofId(layer.id()).displayName(layer.name()).typeRaster().source((TileSource)layer).minZoom(0);
            if (!layer.equals(OSM_BACKGROUND)) {
                builder.intiallyHidden();
            }
            return builder;
        }).toList();
    }

    private static List<StyleBuilder> stops(VectorSourceLayer regularStops, VectorSourceLayer areaStops, VectorSourceLayer groupStops) {
        return List.of(StyleBuilder.ofId("area-stop").group(STOPS_GROUP).typeFill().vectorSourceLayer(areaStops).fillColor(BRIGHT_GREEN).fillOpacity(0.5f).fillOutlineColor(BLACK).minZoom(6).maxZoom(23), StyleBuilder.ofId("group-stop").group(STOPS_GROUP).typeFill().vectorSourceLayer(groupStops).fillColor(BRIGHT_GREEN).fillOpacity(0.5f).fillOutlineColor(BLACK).minZoom(6).maxZoom(23), StyleBuilder.ofId("regular-stop").group(STOPS_GROUP).typeCircle().vectorSourceLayer(regularStops).circleStroke(BLACK, LARGE_CIRCLE_LINE_WIDTH).circleRadius(LARGE_CIRCLE_RADIUS).circleColor("#fcf9fa").minZoom(10).maxZoom(23));
    }

    private static List<StyleBuilder> vertices(VectorSourceLayer vertices) {
        return List.of(StyleBuilder.ofId("vertex").group(VERTICES_GROUP).typeCircle().vectorSourceLayer(vertices).circleStroke(BLACK, CIRCLE_STROKE).circleRadius(new ZoomDependentNumber(List.of(new ZoomDependentNumber.ZoomStop(15, 1.0f), new ZoomDependentNumber.ZoomStop(23, 7.0f)))).circleColor(PURPLE).minZoom(15).maxZoom(23).intiallyHidden(), StyleBuilder.ofId("parking-vertex").group(VERTICES_GROUP).typeCircle().vectorSourceLayer(vertices).vertexFilter(VehicleParkingEntranceVertex.class).circleStroke(BLACK, CIRCLE_STROKE).circleRadius(MEDIUM_CIRCLE_RADIUS).circleColor(DARK_GREEN).minZoom(13).maxZoom(23).intiallyHidden());
    }

    private static List<StyleBuilder> rental(VectorSourceLayer layer) {
        return List.of(StyleBuilder.ofId("rental-vehicle").group(RENTAL_GROUP).typeCircle().vectorSourceLayer(layer).classFilter(VehicleRentalVehicle.class).circleStroke(BLACK, CIRCLE_STROKE).circleRadius(MEDIUM_CIRCLE_RADIUS).circleColor(TEAL).minZoom(13).maxZoom(23).intiallyHidden(), StyleBuilder.ofId("rental-station").group(RENTAL_GROUP).typeCircle().vectorSourceLayer(layer).classFilter(VehicleRentalStation.class).circleStroke(BLACK, LARGE_CIRCLE_LINE_WIDTH).circleRadius(LARGE_CIRCLE_RADIUS).circleColor(TURQUOISE).minZoom(13).maxZoom(23).intiallyHidden());
    }

    private static List<StyleBuilder> edges(VectorSourceLayer edges) {
        return List.of(StyleBuilder.ofId("edge").group(EDGES_GROUP).typeLine().vectorSourceLayer(edges).lineColor(MAGENTA).edgeFilter(EDGES_TO_DISPLAY).lineWidth(LINE_HALF_WIDTH).lineOffset(LINE_OFFSET).minZoom(6).maxZoom(23).intiallyHidden(), StyleBuilder.ofId("edge-name").group(EDGES_GROUP).typeSymbol().lineText("name").vectorSourceLayer(edges).edgeFilter(EDGES_TO_DISPLAY).minZoom(17).maxZoom(23).intiallyHidden(), StyleBuilder.ofId("link").group(EDGES_GROUP).typeLine().vectorSourceLayer(edges).lineColor(BRIGHT_GREEN).edgeFilter(StreetTransitStopLink.class, StreetTransitEntranceLink.class, BoardingLocationToStopLink.class, StreetVehicleRentalLink.class, StreetVehicleParkingLink.class, StreetStationCentroidLink.class).lineWidth(LINE_WIDTH).lineOffset(LINE_OFFSET).minZoom(13).maxZoom(23).intiallyHidden());
    }

    private static List<StyleBuilder> elevation(VectorSourceLayer edges, VectorSourceLayer vertices) {
        return List.of(StyleBuilder.ofId("maximum-slope").group(ELEVATION_GROUP).typeLine().vectorSourceLayer(edges).lineColorFromProperty("maximumSlope", 0.0, 0.35).edgeFilter(StreetEdge.class).lineWidth(LINE_HALF_WIDTH).lineOffset(LINE_OFFSET).minZoom(6).maxZoom(23).intiallyHidden(), StyleBuilder.ofId("vertex-elevation").group(ELEVATION_GROUP).typeSymbol().symbolText("elevation").vectorSourceLayer(vertices).minZoom(17).maxZoom(23).intiallyHidden());
    }

    private static List<StyleBuilder> bicycleSafety(VectorSourceLayer edges) {
        return List.of(StyleBuilder.ofId("bicycle-safety").group(BICYCLE_SAFETY_GROUP).typeLine().vectorSourceLayer(edges).log2LineColorFromProperty("bicycleSafetyFactor", 80.0).edgeFilter(StreetEdge.class).lineWidth(LINE_HALF_WIDTH).lineOffset(LINE_OFFSET).minZoom(6).maxZoom(23).intiallyHidden(), StyleBuilder.ofId("bicycle-safety-text").vectorSourceLayer(edges).group(BICYCLE_SAFETY_GROUP).typeSymbol().lineText("bicycleSafetyFactor").textOffset(1.0f).edgeFilter(EDGES_TO_DISPLAY).minZoom(17).maxZoom(23).intiallyHidden());
    }

    private static List<StyleBuilder> walkSafety(VectorSourceLayer edges) {
        return List.of(StyleBuilder.ofId("walk-safety").group(WALK_SAFETY_GROUP).typeLine().vectorSourceLayer(edges).log2LineColorFromProperty("walkSafetyFactor", 80.0).edgeFilter(StreetEdge.class).lineWidth(LINE_HALF_WIDTH).lineOffset(LINE_OFFSET).minZoom(6).maxZoom(23).intiallyHidden(), StyleBuilder.ofId("walk-safety-text").vectorSourceLayer(edges).group(WALK_SAFETY_GROUP).typeSymbol().lineText("walkSafetyFactor").textOffset(1.0f).edgeFilter(EDGES_TO_DISPLAY).minZoom(17).maxZoom(23).intiallyHidden());
    }

    private static List<StyleBuilder> traversalPermissions(VectorSourceLayer edges) {
        List<StyleBuilder> permissionStyles = Arrays.stream(streetModes).map(streetTraversalPermission -> StyleBuilder.ofId("permission " + String.valueOf(streetTraversalPermission)).vectorSourceLayer(edges).group(PERMISSIONS_GROUP).typeLine().filterValueInProperty("permission", streetTraversalPermission.name(), StreetTraversalPermission.ALL.name()).lineCap("butt").lineColorMatch("permission", DebugStyleSpec.permissionColors(), BLACK).lineWidth(LINE_WIDTH).lineOffset(LINE_OFFSET).minZoom(13).maxZoom(23).intiallyHidden()).toList();
        StyleBuilder textStyle = StyleBuilder.ofId("permission-text").vectorSourceLayer(edges).group(PERMISSIONS_GROUP).typeSymbol().lineText("permission").textOffset(1.0f).edgeFilter(EDGES_TO_DISPLAY).minZoom(17).maxZoom(23).intiallyHidden();
        return ListUtils.combine((Collection[])new Collection[]{permissionStyles, List.of(textStyle)});
    }

    private static List<StyleBuilder> noThruTraffic(VectorSourceLayer edges) {
        List<StyleBuilder> noThruTrafficStyles = Arrays.stream(streetModes).map(streetTraversalPermission -> StyleBuilder.ofId("no-thru-traffic " + String.valueOf(streetTraversalPermission)).vectorSourceLayer(edges).group(NO_THRU_TRAFFIC_GROUP).typeLine().filterValueInProperty("noThruTraffic", streetTraversalPermission.name(), StreetTraversalPermission.ALL.name()).lineCap("butt").lineColorMatch("noThruTraffic", DebugStyleSpec.permissionColors(), BLACK).lineWidth(LINE_WIDTH).lineOffset(LINE_OFFSET).minZoom(13).maxZoom(23).intiallyHidden()).toList();
        StyleBuilder textStyle = StyleBuilder.ofId("no-thru-traffic-text").vectorSourceLayer(edges).group(NO_THRU_TRAFFIC_GROUP).typeSymbol().lineText("noThruTraffic").textOffset(1.0f).edgeFilter(EDGES_TO_DISPLAY).minZoom(17).maxZoom(23).intiallyHidden();
        return ListUtils.combine((Collection[])new Collection[]{noThruTrafficStyles, List.of(textStyle)});
    }

    private static List<String> permissionColors() {
        return Arrays.stream(StreetTraversalPermission.values()).flatMap(p -> Stream.of(EdgePropertyMapper.streetPermissionAsString(p), DebugStyleSpec.permissionColor(p))).toList();
    }

    private static List<StyleBuilder> wheelchair(VectorSourceLayer edges) {
        return List.of(StyleBuilder.ofId("wheelchair-accessible").vectorSourceLayer(edges).group(WHEELCHAIR_GROUP).typeLine().lineColor(DARK_GREEN).booleanFilter("wheelchairAccessible", true).lineWidth(LINE_WIDTH).lineOffset(LINE_OFFSET).minZoom(6).maxZoom(23).intiallyHidden(), StyleBuilder.ofId("wheelchair-inaccessible").vectorSourceLayer(edges).group(WHEELCHAIR_GROUP).typeLine().lineColor(RED).booleanFilter("wheelchairAccessible", false).lineWidth(LINE_WIDTH).lineOffset(LINE_OFFSET).minZoom(6).maxZoom(23).intiallyHidden());
    }

    private static String permissionColor(StreetTraversalPermission p) {
        return switch (p) {
            default -> throw new MatchException(null, null);
            case StreetTraversalPermission.NONE -> BLACK;
            case StreetTraversalPermission.PEDESTRIAN -> "#2ba812";
            case StreetTraversalPermission.BICYCLE, StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE -> "#10d3b6";
            case StreetTraversalPermission.CAR -> "#f92e13";
            case StreetTraversalPermission.BICYCLE_AND_CAR, StreetTraversalPermission.PEDESTRIAN_AND_CAR -> "#e25f8f";
            case StreetTraversalPermission.ALL -> "#adb2b0";
        };
    }
}

