/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.support;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OneOfInputValidator {
    public static String validateOneOf(Map<String, Object> map, String inputTypeName, String ... definedFields) {
        Collection c;
        List<String> fieldsInInput = Arrays.stream(definedFields).map(k -> map.containsKey(k) ? k : null).filter(Objects::nonNull).toList();
        if (fieldsInInput.isEmpty()) {
            throw new IllegalArgumentException("No entries in '%s @oneOf'. One of '%s' must be set.".formatted(inputTypeName, String.join((CharSequence)"', '", definedFields)));
        }
        if (fieldsInInput.size() > 1) {
            throw new IllegalArgumentException("Only one entry in '%s @oneOf' is allowed. Set: '%s'".formatted(inputTypeName, String.join((CharSequence)"', '", fieldsInInput)));
        }
        String field = fieldsInInput.getFirst();
        Object object = map.get(field);
        if (object instanceof Collection && (c = (Collection)object).isEmpty()) {
            throw new IllegalArgumentException("'%s' can not be empty in '%s @oneOf'.".formatted(field, inputTypeName));
        }
        return field;
    }
}

