/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.support;

import graphql.ErrorClassification;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import jakarta.ws.rs.core.Response;
import org.opentripplanner.framework.graphql.GraphQLResponseSerializer;
import org.opentripplanner.framework.http.OtpHttpStatus;

public class ExecutionResultMapper {
    private static final ErrorClassification API_PROCESSING_TIMEOUT = ErrorClassification.errorClassification((String)"ApiProcessingTimeout");
    private static final ErrorClassification RESPONSE_TOO_LARGE = ErrorClassification.errorClassification((String)"ResponseTooLarge");
    private static final ErrorClassification BAD_REQUEST_ERROR = ErrorClassification.errorClassification((String)"BadRequestError");
    private static final ErrorClassification INTERNAL_SERVER_ERROR = ErrorClassification.errorClassification((String)"InternalServerError");

    public static Response okResponse(ExecutionResult result) {
        return Response.ok((Object)GraphQLResponseSerializer.serialize(result)).build();
    }

    public static Response timeoutResponse() {
        return ExecutionResultMapper.unprocessableResponse(API_PROCESSING_TIMEOUT, "TIMEOUT! The request is too resource intensive.");
    }

    public static Response tooLargeResponse(String message) {
        return ExecutionResultMapper.unprocessableResponse(RESPONSE_TOO_LARGE, message);
    }

    public static Response badRequestResponse(String message) {
        GraphQLError error = GraphQLError.newError().errorType(BAD_REQUEST_ERROR).message(message, new Object[0]).build();
        ExecutionResult result = ExecutionResult.newExecutionResult().addError(error).build();
        return ExecutionResultMapper.response(result, (Response.StatusType)Response.Status.BAD_REQUEST);
    }

    public static Response systemErrorResponse(String message) {
        GraphQLError error = GraphQLError.newError().errorType(INTERNAL_SERVER_ERROR).message(message, new Object[0]).build();
        ExecutionResult result = ExecutionResult.newExecutionResult().addError(error).build();
        return ExecutionResultMapper.response(result, (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR);
    }

    public static Response response(ExecutionResult result, Response.StatusType status) {
        return Response.status((int)status.getStatusCode()).entity((Object)GraphQLResponseSerializer.serialize(result)).build();
    }

    private static Response unprocessableResponse(ErrorClassification errorClassification, String message) {
        GraphQLError error = GraphQLError.newError().errorType(errorClassification).message(message, new Object[0]).build();
        ExecutionResult result = ExecutionResult.newExecutionResult().addError(error).build();
        return ExecutionResultMapper.response(result, OtpHttpStatus.STATUS_UNPROCESSABLE_ENTITY);
    }
}

