/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.support;

import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionStrategyParameters;
import graphql.schema.DataFetchingEnvironment;
import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import org.opentripplanner.apis.support.graphql.LoggingDataFetcherExceptionHandler;
import org.opentripplanner.apis.transmodel.ResponseTooLargeException;
import org.opentripplanner.framework.application.OTPRequestTimeoutException;
import org.opentripplanner.utils.logging.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbortOnUnprocessableRequestExecutionStrategy
extends AsyncExecutionStrategy
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(AbortOnUnprocessableRequestExecutionStrategy.class);
    public static final int LOG_STEPS = 25000;
    private final ProgressTracker timeoutProgressTracker = ProgressTracker.track((String)"Unprocessable request. Abort GraphQL query", (int)25000, (long)-1L);

    public AbortOnUnprocessableRequestExecutionStrategy() {
        super((DataFetcherExceptionHandler)new LoggingDataFetcherExceptionHandler());
    }

    protected <T> CompletableFuture<T> handleFetchingException(DataFetchingEnvironment environment, ExecutionStrategyParameters params, Throwable e) {
        if (e instanceof OTPRequestTimeoutException || e instanceof ResponseTooLargeException) {
            this.logCancellationProgress();
            throw (RuntimeException)e;
        }
        return super.handleFetchingException(environment, params, e);
    }

    private void logCancellationProgress() {
        this.timeoutProgressTracker.startOrStep(m -> LOG.info(m));
    }

    @Override
    public void close() {
        this.timeoutProgressTracker.completeIfHasSteps(m -> LOG.info(m));
    }
}

