/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.model.timetable;

import graphql.Scalars;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.time.LocalDate;
import java.util.Collection;
import org.opentripplanner.api.model.transit.FeedScopedIdMapper;
import org.opentripplanner.apis.transmodel.model.EnumTypes;
import org.opentripplanner.apis.transmodel.model.framework.TransmodelScalars;
import org.opentripplanner.apis.transmodel.support.GqlUtil;
import org.opentripplanner.transit.api.model.FilterValues;
import org.opentripplanner.transit.api.model.RequiredFilterValues;
import org.opentripplanner.transit.api.request.TripOnServiceDateRequest;
import org.opentripplanner.transit.api.request.TripOnServiceDateRequestBuilder;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.timetable.TripAlteration;

public class DatedServiceJourneyQuery {
    private final FeedScopedIdMapper idMapper;

    public DatedServiceJourneyQuery(FeedScopedIdMapper idMapper) {
        this.idMapper = idMapper;
    }

    public GraphQLFieldDefinition createGetById(GraphQLOutputType datedServiceJourneyType) {
        return GraphQLFieldDefinition.newFieldDefinition().name("datedServiceJourney").type(datedServiceJourneyType).description("Get a single dated service journey based on its id").argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)Scalars.GraphQLString)).dataFetcher(environment -> {
            FeedScopedId id = this.idMapper.parseNullSafe((String)environment.getArgument("id")).orElse(null);
            return GqlUtil.getTransitService(environment).getTripOnServiceDate(id);
        }).build();
    }

    public GraphQLFieldDefinition createQuery(GraphQLOutputType datedServiceJourneyType) {
        return GraphQLFieldDefinition.newFieldDefinition().name("datedServiceJourneys").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)datedServiceJourneyType)))).description("Get all dated service journeys, matching the filters").argument(GraphQLArgument.newArgument().name("lines").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)))).argument(GraphQLArgument.newArgument().name("serviceJourneys").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)))).argument(GraphQLArgument.newArgument().name("privateCodes").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)))).argument(GraphQLArgument.newArgument().name("operatingDays").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)TransmodelScalars.DATE_SCALAR))))).argument(GraphQLArgument.newArgument().name("alterations").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)EnumTypes.SERVICE_ALTERATION)))).argument(GraphQLArgument.newArgument().name("authorities").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)))).argument(GraphQLArgument.newArgument().name("replacementFor").description("Get all DatedServiceJourneys, which are replacing any of the given DatedServiceJourneys ids").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)))).dataFetcher(environment -> {
            FilterValues<FeedScopedId> authorities = FilterValues.ofEmptyIsEverything("authorities", this.idMapper.parseListNullSafe((Collection)environment.getArgument("authorities")));
            FilterValues<FeedScopedId> lines = FilterValues.ofEmptyIsEverything("lines", this.idMapper.parseListNullSafe((Collection)environment.getArgument("lines")));
            FilterValues<FeedScopedId> serviceJourneys = FilterValues.ofEmptyIsEverything("serviceJourneys", this.idMapper.parseListNullSafe((Collection)environment.getArgument("serviceJourneys")));
            FilterValues<FeedScopedId> replacementFor = FilterValues.ofEmptyIsEverything("replacementFor", this.idMapper.parseListNullSafe((Collection)environment.getArgument("replacementFor")));
            FilterValues<String> privateCodes = FilterValues.ofEmptyIsEverything("privateCodes", (Collection)environment.getArgument("privateCodes"));
            RequiredFilterValues<LocalDate> operatingDays = FilterValues.ofRequired("operatingDays", (Collection)environment.getArgument("operatingDays"));
            FilterValues<TripAlteration> alterations = FilterValues.ofEmptyIsEverything("alterations", (Collection)environment.getArgument("alterations"));
            TripOnServiceDateRequestBuilder tripOnServiceDateRequestBuilder = TripOnServiceDateRequest.of(operatingDays).withAgencies(authorities).withRoutes(lines).withServiceJourneys(serviceJourneys).withReplacementFor(replacementFor);
            tripOnServiceDateRequestBuilder = tripOnServiceDateRequestBuilder.withNetexInternalPlanningCodes(privateCodes);
            tripOnServiceDateRequestBuilder = tripOnServiceDateRequestBuilder.withAlterations(alterations);
            return GqlUtil.getTransitService(environment).findTripsOnServiceDate(tripOnServiceDateRequestBuilder.build());
        }).build();
    }
}

