/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.model.siri.sx;

import graphql.Scalars;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import org.opentripplanner.apis.transmodel.model.EnumTypes;
import org.opentripplanner.apis.transmodel.model.framework.TransmodelScalars;
import org.opentripplanner.apis.transmodel.model.stop.StopPlaceType;
import org.opentripplanner.apis.transmodel.support.GqlUtil;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.timetable.TripIdAndServiceDate;

public class AffectsType {
    private static final String NAME = "Affects";

    public static GraphQLOutputType create(GraphQLOutputType quayType, GraphQLOutputType stopPlaceType, GraphQLOutputType lineType, GraphQLOutputType serviceJourneyType, GraphQLOutputType datedServiceJourneyType) {
        GraphQLObjectType affectedStopPlace = GraphQLObjectType.newObject().name("AffectedStopPlace").field(GraphQLFieldDefinition.newFieldDefinition().name("quay").type(quayType).dataFetcher(environment -> {
            FeedScopedId stopId = ((EntitySelector.Stop)environment.getSource()).stopId();
            return GqlUtil.getTransitService(environment).getRegularStop(stopId);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("stopPlace").type(stopPlaceType).dataFetcher(environment -> {
            FeedScopedId stopId = ((EntitySelector.Stop)environment.getSource()).stopId();
            return StopPlaceType.fetchStopPlaceById(stopId, environment);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("stopConditions").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)EnumTypes.STOP_CONDITION_ENUM)))).build()).build();
        GraphQLObjectType affectedLine = GraphQLObjectType.newObject().name("AffectedLine").field(GraphQLFieldDefinition.newFieldDefinition().name("line").type(lineType).dataFetcher(environment -> {
            FeedScopedId routeId = ((EntitySelector.Route)environment.getSource()).routeId();
            return GqlUtil.getTransitService(environment).getRoute(routeId);
        }).build()).build();
        GraphQLObjectType affectedServiceJourney = GraphQLObjectType.newObject().name("AffectedServiceJourney").field(GraphQLFieldDefinition.newFieldDefinition().name("serviceJourney").type(serviceJourneyType).dataFetcher(environment -> {
            FeedScopedId tripId = ((EntitySelector.Trip)environment.getSource()).tripId();
            return GqlUtil.getTransitService(environment).getTrip(tripId);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("operatingDay").type((GraphQLOutputType)TransmodelScalars.DATE_SCALAR).dataFetcher(environment -> ((EntitySelector.Trip)environment.getSource()).serviceDate()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("datedServiceJourney").type(datedServiceJourneyType).dataFetcher(environment -> {
            EntitySelector.Trip entitySelector = (EntitySelector.Trip)environment.getSource();
            return GqlUtil.getTransitService(environment).getTripOnServiceDate(new TripIdAndServiceDate(entitySelector.tripId(), entitySelector.serviceDate()));
        }).build()).build();
        GraphQLObjectType affectedStopPlaceOnLine = GraphQLObjectType.newObject().name("AffectedStopPlaceOnLine").field(GraphQLFieldDefinition.newFieldDefinition().name("quay").type(quayType).dataFetcher(environment -> {
            FeedScopedId stopId = ((EntitySelector.StopAndRoute)environment.getSource()).stopId();
            return GqlUtil.getTransitService(environment).getRegularStop(stopId);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("stopPlace").type(stopPlaceType).dataFetcher(environment -> {
            FeedScopedId stopId = ((EntitySelector.StopAndRoute)environment.getSource()).stopId();
            return StopPlaceType.fetchStopPlaceById(stopId, environment);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("line").type(lineType).dataFetcher(environment -> {
            FeedScopedId routeId = ((EntitySelector.StopAndRoute)environment.getSource()).routeId();
            return GqlUtil.getTransitService(environment).getRoute(routeId);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("stopConditions").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)EnumTypes.STOP_CONDITION_ENUM)))).build()).build();
        GraphQLObjectType affectedStopPlaceOnServiceJourney = GraphQLObjectType.newObject().name("AffectedStopPlaceOnServiceJourney").field(GraphQLFieldDefinition.newFieldDefinition().name("quay").type(quayType).dataFetcher(environment -> {
            FeedScopedId stopId = ((EntitySelector.StopAndTrip)environment.getSource()).stopId();
            return GqlUtil.getTransitService(environment).getRegularStop(stopId);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("stopPlace").type(stopPlaceType).dataFetcher(environment -> {
            FeedScopedId stopId = ((EntitySelector.StopAndTrip)environment.getSource()).stopId();
            return StopPlaceType.fetchStopPlaceById(stopId, environment);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("serviceJourney").type(serviceJourneyType).dataFetcher(environment -> {
            FeedScopedId tripId = ((EntitySelector.StopAndTrip)environment.getSource()).tripId();
            return GqlUtil.getTransitService(environment).getTrip(tripId);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("operatingDay").type((GraphQLOutputType)TransmodelScalars.DATE_SCALAR).dataFetcher(environment -> ((EntitySelector.StopAndTrip)environment.getSource()).serviceDate()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("datedServiceJourney").type(datedServiceJourneyType).dataFetcher(environment -> {
            EntitySelector.StopAndTrip entitySelector = (EntitySelector.StopAndTrip)environment.getSource();
            return GqlUtil.getTransitService(environment).getTripOnServiceDate(new TripIdAndServiceDate(entitySelector.tripId(), entitySelector.serviceDate()));
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("stopConditions").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)EnumTypes.STOP_CONDITION_ENUM)))).build()).build();
        GraphQLObjectType affectedUnknown = GraphQLObjectType.newObject().name("AffectedUnknown").field(GraphQLFieldDefinition.newFieldDefinition().name("description").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(environment -> {
            Object object = environment.getSource();
            if (object instanceof EntitySelector.Unknown) {
                EntitySelector.Unknown unknownEntitySelector = (EntitySelector.Unknown)object;
                return unknownEntitySelector.description();
            }
            return object.toString();
        }).build()).build();
        return GraphQLUnionType.newUnionType().name(NAME).possibleType(affectedStopPlace).possibleType(affectedLine).possibleType(affectedServiceJourney).possibleType(affectedStopPlaceOnLine).possibleType(affectedStopPlaceOnServiceJourney).possibleType(affectedUnknown).typeResolver(env -> {
            Object object = env.getObject();
            if (object instanceof EntitySelector.Stop) {
                return affectedStopPlace;
            }
            if (object instanceof EntitySelector.Route) {
                return affectedLine;
            }
            if (object instanceof EntitySelector.Trip) {
                return affectedServiceJourney;
            }
            if (object instanceof EntitySelector.StopAndRoute) {
                return affectedStopPlaceOnLine;
            }
            if (object instanceof EntitySelector.StopAndTrip) {
                return affectedStopPlaceOnServiceJourney;
            }
            return affectedUnknown;
        }).build();
    }
}

