/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.model.scalars;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseValueException;
import graphql.schema.GraphQLScalarType;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class LocalTimeScalarFactory {
    private static final String EXAMPLE_TIME = "18:25:SS";
    private static final String TIME_PATTERN = "HH:mm:SS";
    private static final String DATE_SCALAR_DESCRIPTION = "Time using the format: HH:mm:SS. Example: 18:25:SS";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("HH:mm:SS");

    private LocalTimeScalarFactory() {
    }

    public static GraphQLScalarType createLocalTimeScalar() {
        return GraphQLScalarType.newScalar().name("LocalTime").description(DATE_SCALAR_DESCRIPTION).coercing(new Coercing(){

            public String serialize(Object input) {
                if (input instanceof LocalTime) {
                    return FORMATTER.format((LocalTime)input);
                }
                return null;
            }

            public LocalTime parseValue(Object input) {
                try {
                    return LocalTime.from(FORMATTER.parse((CharSequence)input));
                }
                catch (DateTimeParseException dtpe) {
                    throw new CoercingParseValueException("Expected type 'LocalTime' but was '" + String.valueOf(input) + "'.");
                }
            }

            public LocalTime parseLiteral(Object input) {
                if (input instanceof StringValue) {
                    return this.parseValue(((StringValue)input).getValue());
                }
                return null;
            }
        }).build();
    }
}

