/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.model.scalars;

import graphql.language.ArrayValue;
import graphql.language.FloatValue;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;

public class GeoJSONCoordinatesScalar {
    private static final String DOCUMENTATION = "List of coordinates like: [[60.89, 11.12], [62.56, 12.10]]";
    private static final GraphQLScalarType INSTANCE = GraphQLScalarType.newScalar().name("Coordinates").description("List of coordinates like: [[60.89, 11.12], [62.56, 12.10]]").coercing(new Coercing(){

        public List<List<Double>> serialize(Object input) {
            if (input instanceof Coordinate[]) {
                Coordinate[] coordinates = (Coordinate[])input;
                ArrayList<List<Double>> coordinateList = new ArrayList<List<Double>>();
                for (Coordinate coordinate : coordinates) {
                    ArrayList<Double> coordinatePair = new ArrayList<Double>();
                    coordinatePair.add(coordinate.x);
                    coordinatePair.add(coordinate.y);
                    coordinateList.add(coordinatePair);
                }
                return coordinateList;
            }
            return null;
        }

        public Coordinate[] parseValue(Object input) {
            List coordinateList = (List)input;
            Coordinate[] coordinates = new Coordinate[coordinateList.size()];
            for (int i = 0; i < coordinateList.size(); ++i) {
                coordinates[i] = new Coordinate(((Number)((List)coordinateList.get(i)).get(0)).doubleValue(), ((Number)((List)coordinateList.get(i)).get(1)).doubleValue());
            }
            return coordinates;
        }

        public Object parseLiteral(Object input) {
            if (input instanceof ArrayValue) {
                ArrayList coordinateList = (ArrayList)((ArrayValue)input).getValues();
                Coordinate[] coordinates = new Coordinate[coordinateList.size()];
                for (int i = 0; i < coordinateList.size(); ++i) {
                    ArrayValue v = (ArrayValue)coordinateList.get(i);
                    FloatValue longitude = (FloatValue)v.getValues().get(0);
                    FloatValue latitude = (FloatValue)v.getValues().get(1);
                    coordinates[i] = new Coordinate(longitude.getValue().doubleValue(), latitude.getValue().doubleValue());
                }
                return coordinates;
            }
            return null;
        }
    }).build();

    public static GraphQLScalarType getGraphQGeoJSONCoordinatesScalar() {
        return INSTANCE;
    }
}

