/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.model.scalars;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseValueException;
import graphql.schema.GraphQLScalarType;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import org.opentripplanner.utils.time.OffsetDateTimeParser;

public final class DateTimeScalarFactory {
    private static final String DOCUMENTATION = "DateTime format accepting ISO 8601 dates with time zone offset.\n\nFormat:  `YYYY-MM-DD'T'hh:mm[:ss](Z|\u00b101:00)`\n\nExample: `2017-04-23T18:25:43+02:00` or `2017-04-23T16:25:43Z`";
    private static final DateTimeFormatter PARSER = OffsetDateTimeParser.LENIENT_PARSER;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;

    private DateTimeScalarFactory() {
    }

    public static GraphQLScalarType createMillisecondsSinceEpochAsDateTimeStringScalar(final ZoneId timeZone) {
        return GraphQLScalarType.newScalar().name("DateTime").description(DOCUMENTATION).coercing((Coercing)new Coercing<Object, Object>(){

            public String serialize(Object input) {
                if (input instanceof Long) {
                    Long inputAsLong = (Long)input;
                    return Instant.ofEpochMilli(inputAsLong).atZone(timeZone).format(FORMATTER);
                }
                return null;
            }

            public Long parseValue(Object input) {
                Instant instant = null;
                if (input instanceof CharSequence) {
                    CharSequence inputAsCharSequence = (CharSequence)input;
                    try {
                        TemporalAccessor temporalAccessor = PARSER.parseBest(inputAsCharSequence, OffsetDateTime::from, ZonedDateTime::from, LocalDateTime::from);
                        if (temporalAccessor instanceof LocalDateTime) {
                            LocalDateTime localDateTime = (LocalDateTime)temporalAccessor;
                            instant = localDateTime.atZone(timeZone).toInstant();
                        } else {
                            instant = Instant.from(temporalAccessor);
                        }
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        // empty catch block
                    }
                }
                if (instant == null) {
                    throw new CoercingParseValueException("Expected type 'DateTime' but was '" + String.valueOf(input) + "'.");
                }
                return instant.toEpochMilli();
            }

            public Long parseLiteral(Object input) {
                if (input instanceof StringValue) {
                    StringValue inputAsStringValue = (StringValue)input;
                    return this.parseValue(inputAsStringValue.getValue());
                }
                return null;
            }
        }).build();
    }
}

