/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.model.plan;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.opentripplanner.framework.model.TimeAndCost;
import org.opentripplanner.model.plan.Itinerary;

public record TripPlanTimePenaltyDto(String appliesTo, TimeAndCost penalty) {
    static List<TripPlanTimePenaltyDto> of(Itinerary itinerary) {
        return Stream.of(TripPlanTimePenaltyDto.of("access", itinerary.accessPenalty()), TripPlanTimePenaltyDto.of("egress", itinerary.egressPenalty())).filter(Objects::nonNull).toList();
    }

    @Nullable
    static TripPlanTimePenaltyDto of(String appliedTo, TimeAndCost penalty) {
        return penalty == null || penalty.isZero() ? null : new TripPlanTimePenaltyDto(appliedTo, penalty);
    }
}

