/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.model.plan;

import graphql.Scalars;
import graphql.language.FloatValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import java.time.Duration;
import java.util.Map;
import org.opentripplanner.framework.graphql.scalar.CostScalarFactory;
import org.opentripplanner.framework.model.Cost;
import org.opentripplanner.routing.api.request.framework.CostLinearFunction;
import org.opentripplanner.utils.time.DurationUtils;

public class RelaxCostType {
    public static final String RATIO = "ratio";
    public static final String CONSTANT = "constant";
    static final GraphQLInputObjectType INPUT_TYPE = GraphQLInputObjectType.newInputObject().name("RelaxCostInput").description("A relax-cost is used to increase the limit when comparing one cost to another cost.\nThis is used to include more results into the result. A `ratio=2.0` means a path (itinerary)\nwith twice as high cost as another one, is accepted. A `constant=$300` means a \"fixed\"\nconstant is added to the limit. A `{ratio=1.0, constant=0}` is said to be the NORMAL relaxed\ncost - the limit is the same as the cost used to calculate the limit. The NORMAL is usually\nthe default. We can express the RelaxCost as a function `f(t) = constant + ratio * t`.\n`f(t)=t` is the NORMAL function.\n").field(GraphQLInputObjectField.newInputObjectField().name("ratio").description("The factor to multiply with the 'other cost'. Minimum value is 1.0.").defaultValueLiteral((Value)FloatValue.of((double)1.0)).type((GraphQLInputType)Scalars.GraphQLFloat).build()).field(GraphQLInputObjectField.newInputObjectField().name("constant").description("The constant value to add to the limit. Must be a positive number. The value is equivalent to transit-cost-seconds. Integers are treated as seconds, but you may use the duration format. Example: '3665 = 'DT1h1m5s' = '1h1m5s'.").defaultValueProgrammatic((Object)"0s").type((GraphQLInputType)CostScalarFactory.costScalar()).build()).build();

    public static ObjectValue valueOf(CostLinearFunction value) {
        return ObjectValue.newObjectValue().objectField(ObjectField.newObjectField().name(RATIO).value((Value)FloatValue.of((double)value.coefficient())).build()).objectField(ObjectField.newObjectField().name(CONSTANT).value((Value)StringValue.of((String)DurationUtils.durationToStr((Duration)((Cost)value.constant()).asDuration()))).build()).build();
    }

    public static CostLinearFunction mapToDomain(Map<String, Object> input, CostLinearFunction defaultValue) {
        if (input == null || input.isEmpty()) {
            return defaultValue;
        }
        double ratio = 1.0;
        Cost constant = Cost.ZERO;
        if (input.containsKey(RATIO)) {
            ratio = (Double)input.get(RATIO);
        }
        if (input.containsKey(CONSTANT)) {
            constant = (Cost)input.get(CONSTANT);
        }
        return CostLinearFunction.of(constant, ratio);
    }
}

