/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.model.plan;

import graphql.Scalars;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import org.opentripplanner.apis.transmodel.mapping.RelativeDirectionMapper;
import org.opentripplanner.apis.transmodel.model.EnumTypes;
import org.opentripplanner.apis.transmodel.model.plan.ElevationProfileStepType;
import org.opentripplanner.framework.graphql.GraphQLUtils;
import org.opentripplanner.model.plan.walkstep.WalkStep;

public class PathGuidanceType {
    public static GraphQLObjectType create(GraphQLObjectType elevationStepType) {
        return GraphQLObjectType.newObject().name("PathGuidance").description("A series of turn by turn instructions used for walking, biking and driving.").field(GraphQLFieldDefinition.newFieldDefinition().name("distance").description("The distance in meters that this step takes.").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(environment -> ((WalkStep)environment.getSource()).getDistance()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("relativeDirection").description("The relative direction of this step.").type((GraphQLOutputType)EnumTypes.RELATIVE_DIRECTION).dataFetcher(environment -> RelativeDirectionMapper.map(((WalkStep)environment.getSource()).getRelativeDirection())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("streetName").description("The name of the street.").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(environment -> GraphQLUtils.getTranslation(((WalkStep)environment.getSource()).getDirectionText(), environment)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("heading").description("The absolute direction of this step.").type((GraphQLOutputType)EnumTypes.ABSOLUTE_DIRECTION).dataFetcher(environment -> ((WalkStep)environment.getSource()).getAbsoluteDirection().orElse(null)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("exit").description("When exiting a highway or traffic circle, the exit name/number.").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(environment -> ((WalkStep)environment.getSource()).highwayExit().orElse(null)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("stayOn").description("Indicates whether or not a street changes direction at an intersection.").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(environment -> ((WalkStep)environment.getSource()).isStayOn()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("area").description("This step is on an open area, such as a plaza or train platform, and thus the directions should say something like \"cross\"").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(environment -> ((WalkStep)environment.getSource()).getArea()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bogusName").description("The name of this street was generated by the system, so we should only display it once, and generally just display right/left directions").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(environment -> ((WalkStep)environment.getSource()).nameIsDerived()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("latitude").description("The latitude of the step.").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(environment -> ((WalkStep)environment.getSource()).getStartLocation().latitude()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("longitude").description("The longitude of the step.").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(environment -> ((WalkStep)environment.getSource()).getStartLocation().longitude()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("elevationProfile").description(ElevationProfileStepType.makeDescription("step")).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)elevationStepType))).dataFetcher(environment -> ElevationProfileStepType.mapElevationProfile(((WalkStep)environment.getSource()).getElevationProfile())).build()).build();
    }
}

