/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.model.plan;

import graphql.Scalars;
import graphql.scalars.ExtendedScalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.apis.transmodel.model.EnumTypes;
import org.opentripplanner.apis.transmodel.model.TransmodelTransportSubmode;
import org.opentripplanner.apis.transmodel.model.TripTimeOnDateHelper;
import org.opentripplanner.apis.transmodel.model.framework.TransmodelDirectives;
import org.opentripplanner.apis.transmodel.model.framework.TransmodelScalars;
import org.opentripplanner.apis.transmodel.model.plan.ElevationProfileStepType;
import org.opentripplanner.apis.transmodel.support.GqlUtil;
import org.opentripplanner.framework.geometry.EncodedPolyline;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.TransitLeg;
import org.opentripplanner.model.plan.leg.StopArrival;
import org.opentripplanner.model.plan.leg.StreetLeg;
import org.opentripplanner.model.plan.legreference.LegReferenceSerializer;
import org.opentripplanner.routing.alternativelegs.AlternativeLegs;
import org.opentripplanner.routing.alternativelegs.AlternativeLegsFilter;
import org.opentripplanner.routing.alternativelegs.NavigationDirection;

public class LegType {
    private static final String NAME = "Leg";
    public static final GraphQLTypeReference REF = new GraphQLTypeReference("Leg");

    public static GraphQLObjectType create(GraphQLOutputType bookingArrangementType, GraphQLOutputType interchangeType, GraphQLOutputType linkGeometryType, GraphQLOutputType authorityType, GraphQLOutputType operatorType, GraphQLOutputType quayType, GraphQLOutputType estimatedCallType, GraphQLOutputType lineType, GraphQLOutputType serviceJourneyType, GraphQLOutputType datedServiceJourneyType, GraphQLOutputType ptSituationElementType, GraphQLObjectType placeType, GraphQLObjectType pathGuidanceType, GraphQLType elevationStepType, GraphQLObjectType emissionType, GraphQLScalarType dateTimeScalar) {
        return GraphQLObjectType.newObject().name(NAME).description("Part of a trip pattern. Either a ride on a public transport vehicle or access or path link to/from/between places").field(GraphQLFieldDefinition.newFieldDefinition().name("id").description("An identifier for the leg, which can be used to re-fetch transit leg information.").type((GraphQLOutputType)Scalars.GraphQLID).dataFetcher(env -> LegReferenceSerializer.encode(LegType.leg(env).legReference())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("aimedStartTime").description("The aimed date and time this leg starts.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)dateTimeScalar)).dataFetcher(env -> LegType.leg(env).startTime().minusSeconds(LegType.leg(env).departureDelay()).toInstant().toEpochMilli()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("expectedStartTime").description("The expected, real-time adjusted date and time this leg starts.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)dateTimeScalar)).dataFetcher(env -> LegType.leg(env).startTime().toInstant().toEpochMilli()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("aimedEndTime").description("The aimed date and time this leg ends.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)dateTimeScalar)).dataFetcher(env -> LegType.leg(env).endTime().minusSeconds(LegType.leg(env).arrivalDelay()).toInstant().toEpochMilli()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("expectedEndTime").description("The expected, real-time adjusted date and time this leg ends.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)dateTimeScalar)).dataFetcher(env -> LegType.leg(env).endTime().toInstant().toEpochMilli()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("mode").description("The mode of transport or access (e.g., foot) used when traversing this leg.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)EnumTypes.LEG_MODE)).dataFetcher(env -> LegType.onLeg(env, StreetLeg::getMode, TransitLeg::mode)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("transportSubmode").description("The transport sub mode (e.g., localBus or expressBus) used when traversing this leg. Null if leg is not a ride").type((GraphQLOutputType)EnumTypes.TRANSPORT_SUBMODE).dataFetcher(environment -> ((Leg)environment.getSource()).trip() != null ? TransmodelTransportSubmode.fromValue(((Leg)environment.getSource()).trip().getNetexSubMode()) : null).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("duration").description("The leg's duration in seconds").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)ExtendedScalars.GraphQLLong)).dataFetcher(env -> LegType.leg(env).duration().toSeconds()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("directDuration").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)ExtendedScalars.GraphQLLong)).description("NOT IMPLEMENTED").dataFetcher(env -> LegType.leg(env).duration().toSeconds()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("pointsOnLink").description("The leg's geometry.").type(linkGeometryType).dataFetcher(env -> EncodedPolyline.encode((Geometry)LegType.leg(env).legGeometry())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("authority").description("For ride legs, the service authority used for this legs. For non-ride legs, null.").type(authorityType).dataFetcher(env -> LegType.leg(env).agency()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("operator").description("For ride legs, the operator used for this legs. For non-ride legs, null.").type(operatorType).dataFetcher(env -> LegType.leg(env).operator()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("realtime").description("Whether there is real-time data about this leg").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLBoolean)).dataFetcher(env -> LegType.leg(env).isRealTimeUpdated()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("distance").description("The distance traveled while traversing the leg in meters.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).dataFetcher(env -> LegType.leg(env).distanceMeters()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("generalizedCost").description("Generalized cost or weight of the leg. Used for debugging.").type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(env -> LegType.leg(env).generalizedCost()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("ride").description("Whether this leg is a ride leg or not.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLBoolean)).dataFetcher(env -> LegType.leg(env).isTransitLeg()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("walkingBike").description("Whether this leg is walking with a bike.").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(env -> LegType.leg(env).walkingBike()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("rentedBike").description("Whether this leg is with a rented bike.").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(env -> LegType.leg(env).rentedVehicle()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("fromPlace").description("The Place where the leg originates.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)placeType)).dataFetcher(env -> LegType.leg(env).from()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("toPlace").description("The Place where the leg ends.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)placeType)).dataFetcher(env -> LegType.leg(env).to()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("fromEstimatedCall").withDirective(TransmodelDirectives.TIMING_DATA).description("EstimatedCall for the quay where the leg originates.").type(estimatedCallType).dataFetcher(env -> TripTimeOnDateHelper.getTripTimeOnDateForFromPlace((Leg)env.getSource())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("toEstimatedCall").withDirective(TransmodelDirectives.TIMING_DATA).description("EstimatedCall for the quay where the leg ends.").type(estimatedCallType).dataFetcher(env -> TripTimeOnDateHelper.getTripTimeOnDateForToPlace((Leg)env.getSource())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("line").description("For ride legs, the line. For non-ride legs, null.").type(lineType).dataFetcher(env -> LegType.leg(env).route()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("serviceJourney").description("For ride legs, the service journey. For non-ride legs, null.").type(serviceJourneyType).dataFetcher(env -> LegType.leg(env).trip()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("datedServiceJourney").description("The dated service journey used for this leg.").type(datedServiceJourneyType).dataFetcher(env -> LegType.leg(env).tripOnServiceDate()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("serviceDate").description("For transit legs, the service date of the trip. For non-transit legs, null.").type((GraphQLOutputType)TransmodelScalars.DATE_SCALAR).dataFetcher(environment -> Optional.of((Leg)environment.getSource()).map(Leg::serviceDate).orElse(null)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("intermediateQuays").description("For ride legs, intermediate quays between the Place where the leg originates and the Place where the leg ends. For non-ride legs, empty list.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)quayType)))).dataFetcher(env -> {
            List<StopArrival> stops = ((Leg)env.getSource()).listIntermediateStops();
            if (stops == null || stops.isEmpty()) {
                return List.of();
            }
            return stops.stream().map(stop -> stop.place.stop).filter(Objects::nonNull).collect(Collectors.toList());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("intermediateEstimatedCalls").withDirective(TransmodelDirectives.TIMING_DATA).description("For ride legs, estimated calls for quays between the Place where the leg originates and the Place where the leg ends. For non-ride legs, empty list.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)estimatedCallType)))).dataFetcher(env -> TripTimeOnDateHelper.getIntermediateTripTimeOnDatesForLeg((Leg)env.getSource())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("serviceJourneyEstimatedCalls").withDirective(TransmodelDirectives.TIMING_DATA).description("For ride legs, all estimated calls for the service journey. For non-ride legs, empty list.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)estimatedCallType)))).dataFetcher(env -> TripTimeOnDateHelper.getAllTripTimeOnDatesForLegsTrip((Leg)env.getSource())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("situations").description("All relevant situations for this leg").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)ptSituationElementType)))).dataFetcher(env -> LegType.leg(env).listTransitAlerts()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("steps").description("Do we continue from a specified via place").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)pathGuidanceType))).dataFetcher(env -> LegType.leg(env).listWalkSteps()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("interchangeFrom").type(interchangeType).dataFetcher(env -> LegType.leg(env).transferFromPrevLeg()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("interchangeTo").type(interchangeType).dataFetcher(env -> LegType.leg(env).transferToNextLeg()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bookingArrangements").type(bookingArrangementType).dataFetcher(env -> LegType.leg(env).pickupBookingInfo()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikeRentalNetworks").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)Scalars.GraphQLString))).dataFetcher(env -> LegType.leg(env).vehicleRentalNetwork() == null ? List.of() : List.of(LegType.leg(env).vehicleRentalNetwork())).build()).field(GraphQLFieldDefinition.newFieldDefinition().description(ElevationProfileStepType.makeDescription("leg")).name("elevationProfile").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList(elevationStepType))).dataFetcher(env -> ElevationProfileStepType.mapElevationProfile(LegType.leg(env).elevationProfile())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("emission").description("The emission per person").type((GraphQLOutputType)emissionType).dataFetcher(e -> LegType.leg(e).emissionPerPerson()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("previousLegs").description("Fetch the previous legs, which can be used to replace this leg. The replacement legs do arrive/depart from/to the same stop places. It might be necessary to change other legs in an itinerary in order to be able to ride the returned legs.").type((GraphQLOutputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)REF))).argument(GraphQLArgument.newArgument().name("previous").description("Number of earlier legs to return.").defaultValueProgrammatic((Object)1).type((GraphQLInputType)Scalars.GraphQLInt)).argument(GraphQLArgument.newArgument().name("filter").description("Whether the leg should be similar to this leg in some way.").defaultValueProgrammatic((Object)"noFilter").type((GraphQLInputType)EnumTypes.ALTERNATIVE_LEGS_FILTER).build()).dataFetcher(env -> {
            Leg leg = LegType.leg(env);
            if (!leg.isScheduledTransitLeg()) {
                return null;
            }
            return AlternativeLegs.getAlternativeLegs(leg, (Integer)env.getArgument("previous"), GqlUtil.getTransitService(env), NavigationDirection.PREVIOUS, (AlternativeLegsFilter)((Object)((Object)env.getArgument("filter"))));
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("nextLegs").description("Fetch the next legs, which can be used to replace this leg. The replacement legs do arrive/depart from/to the same stop places. It might be necessary to change other legs in an itinerary in order to be able to ride the returned legs.").type((GraphQLOutputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)REF))).argument(GraphQLArgument.newArgument().name("next").description("Number of later legs to return.").defaultValueProgrammatic((Object)1).type((GraphQLInputType)Scalars.GraphQLInt)).argument(GraphQLArgument.newArgument().name("filter").description("Whether the leg should be similar to this leg in some way.").defaultValueProgrammatic((Object)"noFilter").type((GraphQLInputType)EnumTypes.ALTERNATIVE_LEGS_FILTER).build()).dataFetcher(env -> {
            Leg leg = LegType.leg(env);
            if (!leg.isScheduledTransitLeg()) {
                return null;
            }
            return AlternativeLegs.getAlternativeLegs(leg, (Integer)env.getArgument("next"), GqlUtil.getTransitService(env), NavigationDirection.NEXT, (AlternativeLegsFilter)((Object)((Object)env.getArgument("filter"))));
        }).build()).build();
    }

    private static Leg leg(DataFetchingEnvironment environment) {
        return (Leg)environment.getSource();
    }

    private static <S, T> Object onLeg(DataFetchingEnvironment environment, Function<StreetLeg, S> streetLegAccessor, Function<TransitLeg, T> transitLegAccessor) {
        Leg leg = LegType.leg(environment);
        if (leg instanceof StreetLeg) {
            StreetLeg sl = (StreetLeg)leg;
            return streetLegAccessor.apply(sl);
        }
        if (leg instanceof TransitLeg) {
            TransitLeg tl = (TransitLeg)leg;
            return transitLegAccessor.apply(tl);
        }
        throw new IllegalStateException("Unhandled leg type: " + String.valueOf(leg));
    }
}

