/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.model.plan;

import graphql.Scalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeReference;
import java.util.List;
import java.util.Objects;
import org.opentripplanner.model.plan.leg.ElevationProfile;

public class ElevationProfileStepType {
    private static final String NAME = "ElevationProfileStep";
    public static final GraphQLTypeReference REF = new GraphQLTypeReference("ElevationProfileStep");

    static String makeDescription(String name) {
        return "The %s's elevation profile. All elevation values, including the first one, are in meters\nabove sea level. The elevation is negative for places below sea level. The profile\nincludes both the start and end coordinate.\n".formatted(name).stripIndent();
    }

    public static GraphQLObjectType create() {
        return GraphQLObjectType.newObject().name(NAME).description("Individual step of an elevation profile.").field(GraphQLFieldDefinition.newFieldDefinition().name("distance").description("The horizontal distance from the start of the step, in meters.").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(env -> ElevationProfileStepType.step(env).x()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("elevation").description("The elevation at this distance, in meters above sea level. It is negative if the\nlocation is below sea level.\n".stripIndent()).type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(env -> ElevationProfileStepType.step(env).y()).build()).build();
    }

    private static ElevationProfile.Step step(DataFetchingEnvironment environment) {
        return (ElevationProfile.Step)environment.getSource();
    }

    protected static List<ElevationProfile.Step> mapElevationProfile(ElevationProfile profile) {
        return Objects.requireNonNullElse(profile, ElevationProfile.empty()).stepsWithoutUnknowns();
    }
}

