/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.model.framework;

import graphql.Scalars;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opentripplanner.api.model.transit.FeedScopedIdMapper;
import org.opentripplanner.apis.transmodel.model.framework.TransmodelDirectives;
import org.opentripplanner.apis.transmodel.support.GqlUtil;
import org.opentripplanner.transit.model.organization.Agency;

public class AuthorityType {
    private final FeedScopedIdMapper idMapper;

    public AuthorityType(FeedScopedIdMapper idMapper) {
        this.idMapper = idMapper;
    }

    public GraphQLObjectType create(GraphQLOutputType lineType, GraphQLOutputType ptSituationElementType) {
        return GraphQLObjectType.newObject().name("Authority").description("Authority involved in public transportation. An organisation under which the responsibility of organising the transport service in a certain area is placed.").field(GqlUtil.newTransitIdField(this.idMapper)).field(GraphQLFieldDefinition.newFieldDefinition().name("name").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("url").type((GraphQLOutputType)Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("timezone").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("lang").type((GraphQLOutputType)Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("phone").type((GraphQLOutputType)Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("fareUrl").type((GraphQLOutputType)Scalars.GraphQLString).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("lines").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)lineType))).dataFetcher(environment -> GqlUtil.getTransitService(environment).listRoutes().stream().filter(route -> Objects.equals(route.getAgency(), environment.getSource())).collect(Collectors.toList())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("situations").withDirective(TransmodelDirectives.TIMING_DATA).description("Get all situations active for the authority.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)ptSituationElementType)))).dataFetcher(environment -> GqlUtil.getTransitService(environment).getTransitAlertService().getAgencyAlerts(((Agency)environment.getSource()).getId())).build()).build();
    }
}

