/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.model;

import java.time.Instant;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.leg.ScheduledTransitLeg;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.TripTimes;

public class TripTimeOnDateHelper {
    private TripTimeOnDateHelper() {
    }

    @Nullable
    public static TripTimeOnDate getTripTimeOnDateForFromPlace(Leg leg) {
        if (!leg.isScheduledTransitLeg()) {
            return null;
        }
        ScheduledTransitLeg transitLeg = leg.asScheduledTransitLeg();
        return new TripTimeOnDate(transitLeg.tripTimes(), transitLeg.boardStopPosInPattern(), transitLeg.tripPattern(), transitLeg.serviceDate(), transitLeg.serviceDateMidnight());
    }

    @Nullable
    public static TripTimeOnDate getTripTimeOnDateForToPlace(Leg leg) {
        if (!leg.isScheduledTransitLeg()) {
            return null;
        }
        ScheduledTransitLeg transitLeg = leg.asScheduledTransitLeg();
        return new TripTimeOnDate(transitLeg.tripTimes(), transitLeg.alightStopPosInPattern(), transitLeg.tripPattern(), transitLeg.serviceDate(), transitLeg.serviceDateMidnight());
    }

    public static List<TripTimeOnDate> getAllTripTimeOnDatesForLegsTrip(Leg leg) {
        if (!leg.isScheduledTransitLeg()) {
            return List.of();
        }
        ScheduledTransitLeg transitLeg = leg.asScheduledTransitLeg();
        TripTimes tripTimes = transitLeg.tripTimes();
        TripPattern tripPattern = transitLeg.tripPattern();
        Instant serviceDateMidnight = transitLeg.serviceDateMidnight();
        LocalDate serviceDate = transitLeg.serviceDate();
        return IntStream.range(0, tripPattern.numberOfStops()).mapToObj(i -> new TripTimeOnDate(tripTimes, i, tripPattern, serviceDate, serviceDateMidnight)).collect(Collectors.toList());
    }

    public static List<TripTimeOnDate> getIntermediateTripTimeOnDatesForLeg(Leg leg) {
        if (!leg.isScheduledTransitLeg()) {
            return List.of();
        }
        ScheduledTransitLeg transitLeg = leg.asScheduledTransitLeg();
        TripTimes tripTimes = transitLeg.tripTimes();
        TripPattern tripPattern = transitLeg.tripPattern();
        Instant serviceDateMidnight = transitLeg.serviceDateMidnight();
        LocalDate serviceDate = transitLeg.serviceDate();
        return IntStream.range(leg.boardStopPosInPattern() + 1, leg.alightStopPosInPattern()).mapToObj(i -> new TripTimeOnDate(tripTimes, i, tripPattern, serviceDate, serviceDateMidnight)).collect(Collectors.toList());
    }
}

