/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.mapping.preferences;

import graphql.schema.DataFetchingEnvironment;
import org.opentripplanner.apis.transmodel.model.framework.PenaltyForStreetModeType;
import org.opentripplanner.apis.transmodel.model.framework.StreetModeDurationInputType;
import org.opentripplanner.routing.api.request.preference.StreetPreferences;

public class StreetPreferencesMapper {
    public static void mapStreetPreferences(StreetPreferences.Builder street, DataFetchingEnvironment environment, StreetPreferences defaultPreferences) {
        street.withAccessEgress(ae -> {
            ae.withPenalty(b -> PenaltyForStreetModeType.mapPenaltyToDomain(b, environment, "accessEgressPenalty"));
            ae.withMaxDuration(builder -> StreetModeDurationInputType.mapDurationForStreetModeAndAssertValueIsGreaterThenDefault(builder, environment, "maxAccessEgressDurationForMode", defaultPreferences.accessEgress().maxDuration()));
        });
        street.withMaxDirectDuration(builder -> StreetModeDurationInputType.mapDurationForStreetModeAndAssertValueIsGreaterThenDefault(builder, environment, "maxDirectDurationForMode", defaultPreferences.maxDirectDuration()));
    }
}

