/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.mapping.preferences;

import org.opentripplanner.apis.transmodel.mapping.preferences.RentalPreferencesMapper;
import org.opentripplanner.apis.transmodel.support.DataFetcherDecorator;
import org.opentripplanner.routing.api.request.preference.BikePreferences;
import org.opentripplanner.routing.core.VehicleRoutingOptimizeType;

public class BikePreferencesMapper {
    public static final double WALK_BIKE_RELATIVE_RELUCTANCE = 2.7;

    public static void mapBikePreferences(BikePreferences.Builder bike, DataFetcherDecorator callWith) {
        callWith.argument("bikeSpeed", bike::withSpeed);
        callWith.argument("bicycleOptimisationMethod", bike::withOptimizeType);
        callWith.argument("walkReluctance", r -> {
            bike.withReluctance((Double)r);
            bike.withWalking(w -> w.withReluctance(2.7 * (Double)r));
        });
        if (bike.optimizeType() == VehicleRoutingOptimizeType.TRIANGLE) {
            bike.withOptimizeTriangle(triangle -> {
                callWith.argument("triangleFactors.time", triangle::withTime);
                callWith.argument("triangleFactors.slope", triangle::withSlope);
                callWith.argument("triangleFactors.safety", triangle::withSafety);
            });
        }
        bike.withRental(rental -> RentalPreferencesMapper.mapRentalPreferences(rental, callWith));
    }
}

