/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.mapping;

import java.util.List;
import java.util.Map;
import org.opentripplanner.api.model.transit.FeedScopedIdMapper;
import org.opentripplanner.apis.transmodel.mapping.RequestStreetModesMapper;
import org.opentripplanner.apis.transmodel.mapping.TransitFilterNewWayMapper;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.request.JourneyRequest;
import org.opentripplanner.routing.api.request.request.JourneyRequestBuilder;

class ViaSegmentMapper {
    private final TransitFilterNewWayMapper transitFilterNewWayMapper;

    ViaSegmentMapper(FeedScopedIdMapper idMapper) {
        this.transitFilterNewWayMapper = new TransitFilterNewWayMapper(idMapper);
    }

    JourneyRequest mapViaSegment(RouteRequest defaultRequest, Map<String, Object> viaSegment) {
        JourneyRequestBuilder journey = defaultRequest.journey().copyOf();
        if (viaSegment.containsKey("modes")) {
            Map modesInput = (Map)viaSegment.get("modes");
            journey.setModes(RequestStreetModesMapper.mapRequestStreetModes(modesInput));
        }
        if (viaSegment.containsKey("filters")) {
            journey.withTransit(tb -> {
                List filters = (List)viaSegment.get("filters");
                tb.setFilters(this.transitFilterNewWayMapper.mapFilter(filters));
            });
        }
        return journey.build();
    }
}

