/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.mapping;

import graphql.schema.DataFetchingEnvironment;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opentripplanner.api.model.transit.FeedScopedIdMapper;
import org.opentripplanner.apis.transmodel.TransmodelRequestContext;
import org.opentripplanner.apis.transmodel.mapping.GenericLocationMapper;
import org.opentripplanner.apis.transmodel.mapping.ViaLocationDeprecatedMapper;
import org.opentripplanner.apis.transmodel.mapping.ViaSegmentMapper;
import org.opentripplanner.framework.graphql.GraphQLUtils;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.RouteViaRequest;
import org.opentripplanner.routing.api.request.ViaLocationDeprecated;
import org.opentripplanner.routing.api.request.request.JourneyRequest;
import org.opentripplanner.standalone.api.OtpServerRequestContext;

public class ViaRequestMapper {
    private final ViaLocationDeprecatedMapper viaLocationDeprecatedMapper;
    private final GenericLocationMapper genericLocationMapper;
    private final ViaSegmentMapper viaSegmentMapper;

    public ViaRequestMapper(FeedScopedIdMapper idMapper) {
        this.viaLocationDeprecatedMapper = new ViaLocationDeprecatedMapper(idMapper);
        this.genericLocationMapper = new GenericLocationMapper(idMapper);
        this.viaSegmentMapper = new ViaSegmentMapper(idMapper);
    }

    public RouteViaRequest createRouteViaRequest(DataFetchingEnvironment environment) {
        List<JourneyRequest> requests;
        TransmodelRequestContext context = (TransmodelRequestContext)environment.getContext();
        OtpServerRequestContext serverContext = context.getServerContext();
        RouteRequest request = serverContext.defaultRouteRequest();
        List viaInput = (List)environment.getArgument("via");
        List<ViaLocationDeprecated> vias = viaInput.stream().map(this.viaLocationDeprecatedMapper::mapViaLocation).toList();
        if (environment.containsArgument("segments")) {
            List segments = (List)environment.getArgument("segments");
            requests = segments.stream().map(viaRequest -> this.viaSegmentMapper.mapViaSegment(request, (Map<String, Object>)viaRequest)).toList();
        } else {
            requests = Collections.nCopies(vias.size() + 1, request.journey());
        }
        return RouteViaRequest.of(vias, requests).withDateTime(Instant.ofEpochMilli((Long)environment.getArgumentOrDefault("dateTime", (Object)request.dateTime().toEpochMilli()))).withSearchWindow((Duration)environment.getArgumentOrDefault("searchWindow", (Object)request.searchWindow())).withFrom(this.genericLocationMapper.toGenericLocation((Map)environment.getArgument("from"))).withTo(this.genericLocationMapper.toGenericLocation((Map)environment.getArgument("to"))).withNumItineraries((Integer)environment.getArgumentOrDefault("numTripPatterns", (Object)request.numItineraries())).withWheelchair((Boolean)environment.getArgumentOrDefault("wheelchairAccessible", (Object)request.journey().wheelchair())).withLocale(GraphQLUtils.getLocale(environment)).build();
    }
}

