/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.mapping;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.api.model.transit.FeedScopedIdMapper;
import org.opentripplanner.apis.transmodel.model.framework.CoordinateInputType;
import org.opentripplanner.apis.transmodel.support.OneOfInputValidator;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.routing.api.request.via.PassThroughViaLocation;
import org.opentripplanner.routing.api.request.via.ViaLocation;
import org.opentripplanner.routing.api.request.via.VisitViaLocation;
import org.opentripplanner.transit.model.framework.FeedScopedId;

class TripViaLocationMapper {
    private final FeedScopedIdMapper idMapper;

    TripViaLocationMapper(FeedScopedIdMapper idMapper) {
        this.idMapper = idMapper;
    }

    List<ViaLocation> mapToViaLocations(List<Map<String, Object>> via) {
        return via.stream().map(this::mapViaLocation).collect(Collectors.toList());
    }

    @Deprecated
    List<ViaLocation> toLegacyPassThroughLocations(List<Map<String, Object>> passThroughPoints) {
        return passThroughPoints.stream().map(this::mapLegacyPassThroughViaLocation).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private ViaLocation mapViaLocation(Map<String, Object> inputMap) {
        String fieldName = OneOfInputValidator.validateOneOf(inputMap, "via", "visit", "passThrough");
        Map value = (Map)inputMap.get(fieldName);
        return switch (fieldName) {
            case "visit" -> this.mapVisitViaLocation(value);
            case "passThrough" -> this.mapPassThroughViaLocation(value);
            default -> throw new IllegalArgumentException("Unknown field: " + fieldName);
        };
    }

    private VisitViaLocation mapVisitViaLocation(Map<String, Object> inputMap) {
        String label = (String)inputMap.get("label");
        Duration minimumWaitTime = (Duration)inputMap.get("minimumWaitTime");
        List<FeedScopedId> stopLocationIds = this.mapStopLocationIds(inputMap);
        List<WgsCoordinate> coordinate = TripViaLocationMapper.mapCoordinate(inputMap);
        return new VisitViaLocation(label, minimumWaitTime, stopLocationIds, coordinate);
    }

    private PassThroughViaLocation mapPassThroughViaLocation(Map<String, Object> inputMap) {
        String label = (String)inputMap.get("label");
        List<FeedScopedId> stopLocationIds = this.mapStopLocationIds(inputMap);
        return new PassThroughViaLocation(label, stopLocationIds);
    }

    private List<FeedScopedId> mapStopLocationIds(Map<String, Object> map) {
        Collection c = (Collection)map.get("stopLocationIds");
        return c == null ? List.of() : this.idMapper.parseList(c);
    }

    private static List<WgsCoordinate> mapCoordinate(Map<String, Object> map) {
        return CoordinateInputType.mapToWgsCoordinate("coordinate", map).map(List::of).orElseGet(List::of);
    }

    @Deprecated
    @Nullable
    private ViaLocation mapLegacyPassThroughViaLocation(Map<String, Object> inputMap) {
        String name = (String)inputMap.get("name");
        List placeIds = (List)inputMap.get("placeIds");
        if (placeIds == null || placeIds.isEmpty()) {
            return null;
        }
        List<FeedScopedId> stopLocationIds = this.idMapper.parseList(placeIds);
        return new PassThroughViaLocation(name, stopLocationIds);
    }
}

