/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.mapping;

import graphql.schema.DataFetchingEnvironment;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.opentripplanner.api.model.transit.FeedScopedIdMapper;
import org.opentripplanner.apis.transmodel.TransmodelRequestContext;
import org.opentripplanner.apis.transmodel.mapping.GenericLocationMapper;
import org.opentripplanner.apis.transmodel.mapping.PreferencesMapper;
import org.opentripplanner.apis.transmodel.mapping.RequestStreetModesMapper;
import org.opentripplanner.apis.transmodel.mapping.TransitFilterNewWayMapper;
import org.opentripplanner.apis.transmodel.mapping.TransitFilterOldWayMapper;
import org.opentripplanner.apis.transmodel.mapping.TripViaLocationMapper;
import org.opentripplanner.apis.transmodel.support.DataFetcherDecorator;
import org.opentripplanner.apis.transmodel.support.GqlUtil;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.RouteRequestBuilder;
import org.opentripplanner.routing.api.request.request.TransitRequestBuilder;
import org.opentripplanner.standalone.api.OtpServerRequestContext;

public class TripRequestMapper {
    private final TripViaLocationMapper tripViaLocationMapper;
    private final GenericLocationMapper genericLocationMapper;
    private final TransitFilterNewWayMapper transitFilterNewWayMapper;
    private final TransitFilterOldWayMapper transitFilterOldWayMapper;
    private final FeedScopedIdMapper idMapper;

    public TripRequestMapper(FeedScopedIdMapper idMapper) {
        this.tripViaLocationMapper = new TripViaLocationMapper(idMapper);
        this.genericLocationMapper = new GenericLocationMapper(idMapper);
        this.transitFilterNewWayMapper = new TransitFilterNewWayMapper(idMapper);
        this.transitFilterOldWayMapper = new TransitFilterOldWayMapper(idMapper);
        this.idMapper = idMapper;
    }

    public RouteRequest createRequest(DataFetchingEnvironment environment) {
        TransmodelRequestContext context = (TransmodelRequestContext)environment.getContext();
        OtpServerRequestContext serverContext = context.getServerContext();
        RouteRequestBuilder requestBuilder = serverContext.defaultRouteRequest().copyOf();
        DataFetcherDecorator callWith = new DataFetcherDecorator(environment);
        callWith.argument("from", v -> requestBuilder.withFrom(this.genericLocationMapper.toGenericLocation((Map<String, Object>)v)));
        callWith.argument("to", v -> requestBuilder.withTo(this.genericLocationMapper.toGenericLocation((Map<String, Object>)v)));
        callWith.argument("passThroughPoints", v -> requestBuilder.withViaLocations(this.tripViaLocationMapper.toLegacyPassThroughLocations((List<Map<String, Object>>)v)));
        callWith.argument("via", v -> requestBuilder.withViaLocations(this.tripViaLocationMapper.mapToViaLocations((List<Map<String, Object>>)v)));
        callWith.argument("dateTime", millisSinceEpoch -> requestBuilder.withDateTime(Instant.ofEpochMilli((Long)millisSinceEpoch)));
        callWith.argument("bookingTime", millisSinceEpoch -> requestBuilder.withBookingTime(Instant.ofEpochMilli((Long)millisSinceEpoch)));
        callWith.argument("searchWindow", m -> requestBuilder.withSearchWindow(Duration.ofMinutes(m.intValue())));
        callWith.argument("pageCursor", requestBuilder::withPageCursorFromEncoded);
        callWith.argument("timetableView", requestBuilder::withTimetableView);
        callWith.argument("numTripPatterns", requestBuilder::withNumItineraries);
        callWith.argument("arriveBy", requestBuilder::withArriveBy);
        requestBuilder.withJourney(journeyBuilder -> {
            callWith.argument("wheelchairAccessible", journeyBuilder::withWheelchair);
            journeyBuilder.withTransit(transitBuilder -> {
                callWith.argument("unpreferred.authorities", authorities -> transitBuilder.withUnpreferredAgencies(this.idMapper.parseListNullSafe((Collection<String>)authorities)));
                callWith.argument("unpreferred.lines", lines -> transitBuilder.withUnpreferredRoutes(this.idMapper.parseListNullSafe((Collection<String>)lines)));
                callWith.argument("banned.serviceJourneys", serviceJourneys -> transitBuilder.withBannedTrips(this.idMapper.parseListNullSafe((Collection<String>)serviceJourneys)));
                if (GqlUtil.hasArgument(environment, "filters")) {
                    transitBuilder.setFilters(this.transitFilterNewWayMapper.mapFilter((List)environment.getArgument("filters")));
                } else {
                    this.transitFilterOldWayMapper.mapFilter(environment, callWith, (TransitRequestBuilder)transitBuilder);
                }
            });
            if (GqlUtil.hasArgument(environment, "modes")) {
                journeyBuilder.setModes(RequestStreetModesMapper.mapRequestStreetModes((Map)environment.getArgument("modes")));
            }
        });
        requestBuilder.withPreferences(preferences -> PreferencesMapper.mapPreferences(environment, callWith, preferences));
        return requestBuilder.buildRequest();
    }
}

