/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.mapping;

import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.opentripplanner.api.model.transit.FeedScopedIdMapper;
import org.opentripplanner.apis.transmodel.model.TransmodelTransportSubmode;
import org.opentripplanner.apis.transmodel.support.DataFetcherDecorator;
import org.opentripplanner.apis.transmodel.support.GqlUtil;
import org.opentripplanner.routing.api.request.request.TransitRequestBuilder;
import org.opentripplanner.routing.api.request.request.filter.SelectRequest;
import org.opentripplanner.transit.model.basic.MainAndSubMode;
import org.opentripplanner.transit.model.basic.SubMode;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;

class TransitFilterOldWayMapper {
    private final FeedScopedIdMapper idMapper;

    TransitFilterOldWayMapper(FeedScopedIdMapper idMapper) {
        this.idMapper = idMapper;
    }

    void mapFilter(DataFetchingEnvironment environment, DataFetcherDecorator callWith, TransitRequestBuilder transitBuilder) {
        List<MainAndSubMode> tModes;
        if (!(GqlUtil.hasArgument(environment, "modes") && ((Map)environment.getArgument("modes")).containsKey("transportModes") || GqlUtil.hasArgument(environment, "whiteListed") || GqlUtil.hasArgument(environment, "banned"))) {
            return;
        }
        ArrayList<SelectRequest.Builder> selectorBuilders = new ArrayList<SelectRequest.Builder>();
        ArrayList<FeedScopedId> whiteListedAgencies = new ArrayList<FeedScopedId>();
        callWith.argument("whiteListed.authorities", authorities -> whiteListedAgencies.addAll(this.idMapper.parseListNullSafe((Collection<String>)authorities)));
        if (!whiteListedAgencies.isEmpty()) {
            selectorBuilders.add(SelectRequest.of().withAgencies(whiteListedAgencies));
        }
        ArrayList<FeedScopedId> whiteListedLines = new ArrayList<FeedScopedId>();
        callWith.argument("whiteListed.lines", lines -> whiteListedLines.addAll(this.idMapper.parseListNullSafe((Collection<String>)lines)));
        if (!whiteListedLines.isEmpty()) {
            selectorBuilders.add(SelectRequest.of().withRoutes(whiteListedLines));
        }
        if ((tModes = TransitFilterOldWayMapper.mapTransitModes(environment)).isEmpty()) {
            transitBuilder.disable();
            return;
        }
        List<SelectRequest> selectors = TransitFilterOldWayMapper.buildFiltersWithModes(selectorBuilders, tModes);
        transitBuilder.withFilter(filterBuilder -> {
            for (SelectRequest s : selectors) {
                filterBuilder.addSelect(s);
            }
            ArrayList<FeedScopedId> bannedAgencies = new ArrayList<FeedScopedId>();
            callWith.argument("banned.authorities", authorities -> bannedAgencies.addAll(this.idMapper.parseListNullSafe((Collection<String>)authorities)));
            if (!bannedAgencies.isEmpty()) {
                filterBuilder.addNot(SelectRequest.of().withAgencies(bannedAgencies).build());
            }
            ArrayList<FeedScopedId> bannedLines = new ArrayList<FeedScopedId>();
            callWith.argument("banned.lines", lines -> bannedLines.addAll(this.idMapper.parseListNullSafe((Collection<String>)lines)));
            if (!bannedLines.isEmpty()) {
                filterBuilder.addNot(SelectRequest.of().withRoutes(bannedLines).build());
            }
        });
    }

    private static List<MainAndSubMode> mapTransitModes(DataFetchingEnvironment environment) {
        ArrayList<MainAndSubMode> tModes = new ArrayList<MainAndSubMode>();
        if (!GqlUtil.hasArgument(environment, "modes")) {
            return MainAndSubMode.all();
        }
        Map modesInput = (Map)environment.getArgument("modes");
        if (modesInput.get("transportModes") == null) {
            return MainAndSubMode.all();
        }
        List transportModes = (List)modesInput.get("transportModes");
        for (Map modeWithSubmodes : transportModes) {
            if (!modeWithSubmodes.containsKey("transportMode")) continue;
            TransitMode mainMode = (TransitMode)modeWithSubmodes.get("transportMode");
            if (modeWithSubmodes.containsKey("transportSubModes")) {
                List transportSubModes = (List)modeWithSubmodes.get("transportSubModes");
                for (TransmodelTransportSubmode submode : transportSubModes) {
                    tModes.add(new MainAndSubMode(mainMode, SubMode.of(submode.getValue())));
                }
                continue;
            }
            tModes.add(new MainAndSubMode(mainMode));
        }
        return tModes;
    }

    private static List<SelectRequest> buildFiltersWithModes(ArrayList<SelectRequest.Builder> selectors, List<MainAndSubMode> tModes) {
        if (selectors.isEmpty()) {
            return List.of(SelectRequest.of().withTransportModes(tModes).build());
        }
        return selectors.stream().peek(it -> it.withTransportModes(tModes)).map(it -> it.build()).toList();
    }
}

