/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opentripplanner.api.model.transit.FeedScopedIdMapper;
import org.opentripplanner.apis.transmodel.model.TransmodelTransportSubmode;
import org.opentripplanner.routing.api.request.request.filter.SelectRequest;
import org.opentripplanner.transit.model.basic.MainAndSubMode;
import org.opentripplanner.transit.model.basic.SubMode;
import org.opentripplanner.transit.model.basic.TransitMode;

class SelectRequestMapper {
    private final FeedScopedIdMapper idMapper;

    SelectRequestMapper(FeedScopedIdMapper idMapper) {
        this.idMapper = idMapper;
    }

    SelectRequest mapSelectRequest(Map<String, List<?>> input) {
        SelectRequest.Builder selectRequestBuilder = SelectRequest.of();
        if (input.containsKey("lines")) {
            List<String> lines = input.get("lines");
            selectRequestBuilder.withRoutes(this.idMapper.parseListNullSafe(lines));
        }
        if (input.containsKey("authorities")) {
            List<String> authorities = input.get("authorities");
            selectRequestBuilder.withAgencies(this.idMapper.parseListNullSafe(authorities));
        }
        if (input.containsKey("groupOfLines")) {
            List<String> groupOfLines = input.get("groupOfLines");
            selectRequestBuilder.withGroupOfRoutes(this.idMapper.parseListNullSafe(groupOfLines));
        }
        if (input.containsKey("transportModes")) {
            ArrayList<MainAndSubMode> tModes = new ArrayList<MainAndSubMode>();
            List<?> transportModes = input.get("transportModes");
            for (Map modeWithSubModes : transportModes) {
                TransitMode mainMode = (TransitMode)modeWithSubModes.get("transportMode");
                if (modeWithSubModes.containsKey("transportSubModes")) {
                    List transportSubModes = (List)modeWithSubModes.get("transportSubModes");
                    for (TransmodelTransportSubmode subMode : transportSubModes) {
                        tModes.add(new MainAndSubMode(mainMode, SubMode.of(subMode.getValue())));
                    }
                    continue;
                }
                tModes.add(new MainAndSubMode(mainMode));
            }
            selectRequestBuilder.withTransportModes(tModes);
        }
        return selectRequestBuilder.build();
    }
}

