/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.mapping;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.opentripplanner.routing.api.request.RequestModes;
import org.opentripplanner.routing.api.request.RequestModesBuilder;
import org.opentripplanner.routing.api.request.StreetMode;

class RequestStreetModesMapper {
    private static final Predicate<StreetMode> IS_BIKE_OR_CAR = m -> m == StreetMode.BIKE || m == StreetMode.CAR;
    private static final String ACCESS_MODE_KEY = "accessMode";
    private static final String EGRESS_MODE_KEY = "egressMode";
    private static final String DIRECT_MODE_KEY = "directMode";

    RequestStreetModesMapper() {
    }

    static RequestModes mapRequestStreetModes(Map<String, ?> modesInput) {
        RequestModesBuilder mBuilder = RequestModes.of();
        StreetMode accessMode = (StreetMode)modesInput.get(ACCESS_MODE_KEY);
        RequestStreetModesMapper.ensureValueAndSet(accessMode, mBuilder::withAccessMode);
        RequestStreetModesMapper.ensureValueAndSet((StreetMode)modesInput.get(EGRESS_MODE_KEY), mBuilder::withEgressMode);
        RequestStreetModesMapper.ensureValueAndSet((StreetMode)modesInput.get(DIRECT_MODE_KEY), mBuilder::withDirectMode);
        Optional.ofNullable(accessMode).filter(IS_BIKE_OR_CAR).ifPresent(mBuilder::withTransferMode);
        return mBuilder.build();
    }

    private static void ensureValueAndSet(StreetMode streetMode, Consumer<StreetMode> consumer) {
        consumer.accept(streetMode == null ? StreetMode.NOT_SET : streetMode);
    }
}

