/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.mapping;

import graphql.schema.DataFetchingEnvironment;
import java.util.Locale;
import org.opentripplanner.apis.transmodel.mapping.preferences.BikePreferencesMapper;
import org.opentripplanner.apis.transmodel.mapping.preferences.CarPreferencesMapper;
import org.opentripplanner.apis.transmodel.mapping.preferences.ItineraryFilterPreferencesMapper;
import org.opentripplanner.apis.transmodel.mapping.preferences.ScooterPreferencesMapper;
import org.opentripplanner.apis.transmodel.mapping.preferences.StreetPreferencesMapper;
import org.opentripplanner.apis.transmodel.mapping.preferences.TransferPreferencesMapper;
import org.opentripplanner.apis.transmodel.mapping.preferences.TransitPreferencesMapper;
import org.opentripplanner.apis.transmodel.mapping.preferences.WalkPreferencesMapper;
import org.opentripplanner.apis.transmodel.support.DataFetcherDecorator;
import org.opentripplanner.routing.api.request.preference.RoutingPreferencesBuilder;

class PreferencesMapper {
    PreferencesMapper() {
    }

    static void mapPreferences(DataFetchingEnvironment environment, DataFetcherDecorator callWith, RoutingPreferencesBuilder preferences) {
        preferences.withStreet(street -> StreetPreferencesMapper.mapStreetPreferences(street, environment, preferences.street()));
        preferences.withWalk(walk -> WalkPreferencesMapper.mapWalkPreferences(walk, callWith));
        preferences.withBike(bike -> BikePreferencesMapper.mapBikePreferences(bike, callWith));
        preferences.withCar(car -> CarPreferencesMapper.mapCarPreferences(car, callWith));
        preferences.withScooter(scooter -> ScooterPreferencesMapper.mapScooterPreferences(scooter, callWith));
        preferences.withTransfer(transfer -> TransferPreferencesMapper.mapTransferPreferences(transfer, callWith));
        preferences.withTransit(transit -> TransitPreferencesMapper.mapTransitPreferences(transit, environment, callWith));
        preferences.withItineraryFilter(itineraryFilter -> ItineraryFilterPreferencesMapper.mapItineraryFilterPreferences(itineraryFilter, environment, callWith));
        callWith.argument("locale", v -> preferences.withLocale(Locale.forLanguageTag(v)));
    }
}

