/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel.mapping;

import org.opentripplanner.transit.model.timetable.booking.BookingInfo;
import org.opentripplanner.transit.model.timetable.booking.BookingTime;

public class BookingInfoMapper {
    public static String mapToBookWhen(BookingInfo bookingInfo) {
        if (bookingInfo.getMinimumBookingNotice().isPresent()) {
            return null;
        }
        BookingTime latestBookingTime = bookingInfo.getLatestBookingTime();
        BookingTime earliestBookingTime = bookingInfo.getEarliestBookingTime();
        if (earliestBookingTime == null) {
            if (latestBookingTime == null) {
                return "timeOfTravelOnly";
            }
            if (latestBookingTime.getDaysPrior() == 1) {
                return "untilPreviousDay";
            }
            if (latestBookingTime.getDaysPrior() == 0) {
                return "advanceAndDayOfTravel";
            }
            return "other";
        }
        if (earliestBookingTime.getDaysPrior() == 0 && (latestBookingTime == null || latestBookingTime.getDaysPrior() == 0)) {
            return "dayOfTravelOnly";
        }
        return "other";
    }
}

