/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel;

import graphql.Scalars;
import graphql.relay.DefaultConnection;
import graphql.relay.DefaultPageInfo;
import graphql.relay.PageInfo;
import graphql.relay.Relay;
import graphql.relay.SimpleListConnection;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.SchemaTransformer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.api.model.transit.FeedScopedIdMapper;
import org.opentripplanner.apis.support.graphql.injectdoc.ApiDocumentationProfile;
import org.opentripplanner.apis.support.graphql.injectdoc.CustomDocumentation;
import org.opentripplanner.apis.support.graphql.injectdoc.InjectCustomDocumentation;
import org.opentripplanner.apis.transmodel.mapping.PlaceMapper;
import org.opentripplanner.apis.transmodel.mapping.SeverityMapper;
import org.opentripplanner.apis.transmodel.model.DefaultRouteRequestType;
import org.opentripplanner.apis.transmodel.model.EnumTypes;
import org.opentripplanner.apis.transmodel.model.TransmodelPlaceType;
import org.opentripplanner.apis.transmodel.model.framework.AuthorityType;
import org.opentripplanner.apis.transmodel.model.framework.BrandingType;
import org.opentripplanner.apis.transmodel.model.framework.EmissionType;
import org.opentripplanner.apis.transmodel.model.framework.InfoLinkType;
import org.opentripplanner.apis.transmodel.model.framework.MultilingualStringType;
import org.opentripplanner.apis.transmodel.model.framework.NoticeType;
import org.opentripplanner.apis.transmodel.model.framework.OperatorType;
import org.opentripplanner.apis.transmodel.model.framework.PenaltyForStreetModeType;
import org.opentripplanner.apis.transmodel.model.framework.PointsOnLinkType;
import org.opentripplanner.apis.transmodel.model.framework.RentalVehicleTypeType;
import org.opentripplanner.apis.transmodel.model.framework.ServerInfoType;
import org.opentripplanner.apis.transmodel.model.framework.StreetModeDurationInputType;
import org.opentripplanner.apis.transmodel.model.framework.SystemNoticeType;
import org.opentripplanner.apis.transmodel.model.framework.TransmodelDirectives;
import org.opentripplanner.apis.transmodel.model.framework.TransmodelScalars;
import org.opentripplanner.apis.transmodel.model.framework.ValidityPeriodType;
import org.opentripplanner.apis.transmodel.model.network.DestinationDisplayType;
import org.opentripplanner.apis.transmodel.model.network.GroupOfLinesType;
import org.opentripplanner.apis.transmodel.model.network.JourneyPatternType;
import org.opentripplanner.apis.transmodel.model.network.LineType;
import org.opentripplanner.apis.transmodel.model.network.PresentationType;
import org.opentripplanner.apis.transmodel.model.network.StopToStopGeometryType;
import org.opentripplanner.apis.transmodel.model.plan.ElevationProfileStepType;
import org.opentripplanner.apis.transmodel.model.plan.LegType;
import org.opentripplanner.apis.transmodel.model.plan.PathGuidanceType;
import org.opentripplanner.apis.transmodel.model.plan.PlanPlaceType;
import org.opentripplanner.apis.transmodel.model.plan.RoutingErrorType;
import org.opentripplanner.apis.transmodel.model.plan.TripPatternTimePenaltyType;
import org.opentripplanner.apis.transmodel.model.plan.TripPatternType;
import org.opentripplanner.apis.transmodel.model.plan.TripQuery;
import org.opentripplanner.apis.transmodel.model.plan.TripType;
import org.opentripplanner.apis.transmodel.model.plan.legacyvia.ViaLocationInputType;
import org.opentripplanner.apis.transmodel.model.plan.legacyvia.ViaSegmentInputType;
import org.opentripplanner.apis.transmodel.model.plan.legacyvia.ViaTripQuery;
import org.opentripplanner.apis.transmodel.model.plan.legacyvia.ViaTripType;
import org.opentripplanner.apis.transmodel.model.scalars.DateTimeScalarFactory;
import org.opentripplanner.apis.transmodel.model.siri.et.EstimatedCallType;
import org.opentripplanner.apis.transmodel.model.siri.sx.AffectsType;
import org.opentripplanner.apis.transmodel.model.siri.sx.PtSituationElementType;
import org.opentripplanner.apis.transmodel.model.stop.BikeParkType;
import org.opentripplanner.apis.transmodel.model.stop.BikeRentalStationType;
import org.opentripplanner.apis.transmodel.model.stop.MonoOrMultiModalStation;
import org.opentripplanner.apis.transmodel.model.stop.PlaceAtDistanceType;
import org.opentripplanner.apis.transmodel.model.stop.PlaceInterfaceType;
import org.opentripplanner.apis.transmodel.model.stop.QuayAtDistanceType;
import org.opentripplanner.apis.transmodel.model.stop.QuayType;
import org.opentripplanner.apis.transmodel.model.stop.RentalVehicleType;
import org.opentripplanner.apis.transmodel.model.stop.StopPlaceType;
import org.opentripplanner.apis.transmodel.model.stop.TariffZoneType;
import org.opentripplanner.apis.transmodel.model.timetable.BookingArrangementType;
import org.opentripplanner.apis.transmodel.model.timetable.DatedServiceJourneyQuery;
import org.opentripplanner.apis.transmodel.model.timetable.DatedServiceJourneyType;
import org.opentripplanner.apis.transmodel.model.timetable.InterchangeType;
import org.opentripplanner.apis.transmodel.model.timetable.ServiceJourneyType;
import org.opentripplanner.apis.transmodel.model.timetable.TimetabledPassingTimeType;
import org.opentripplanner.apis.transmodel.model.timetable.TripMetadataType;
import org.opentripplanner.apis.transmodel.support.GqlUtil;
import org.opentripplanner.model.plan.legreference.LegReference;
import org.opentripplanner.model.plan.legreference.LegReferenceSerializer;
import org.opentripplanner.model.projectinfo.OtpProjectInfo;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitTuningParameters;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.error.RoutingValidationException;
import org.opentripplanner.routing.graphfinder.PlaceAtDistance;
import org.opentripplanner.routing.graphfinder.PlaceType;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalStation;
import org.opentripplanner.transit.api.model.FilterValues;
import org.opentripplanner.transit.api.request.FindRegularStopsByBoundingBoxRequest;
import org.opentripplanner.transit.api.request.FindRoutesRequest;
import org.opentripplanner.transit.api.request.FindStopLocationsRequest;
import org.opentripplanner.transit.api.request.TripRequest;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.utils.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransmodelGraphQLSchemaFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TransmodelGraphQLSchemaFactory.class);
    private final DefaultRouteRequestType routing;
    private final TransitTuningParameters transitTuningParameters;
    private final ZoneId timeZoneId;
    private final FeedScopedIdMapper idMapper;
    private final ApiDocumentationProfile docProfile;
    private final AuthorityType authorityTypeFactory;
    private final OperatorType operatorTypeFactory;
    private final BrandingType brandingTypeFactory;
    private final NoticeType noticeTypeFactory;
    private final TariffZoneType tariffZoneTypeFactory;
    private final BikeParkType bikeParkTypeFactory;
    private final StopPlaceType stopPlaceTypeFactory;
    private final QuayType quayTypeFactory;
    private final QuayAtDistanceType quayAtDistanceTypeFactory;
    private final LineType lineTypeFactory;
    private final JourneyPatternType journeyPatternTypeFactory;
    private final ServiceJourneyType serviceJourneyTypeFactory;
    private final DatedServiceJourneyType datedServiceJourneyTypeFactory;
    private final TripQuery tripQueryFactory;
    private final ViaTripQuery viaTripQueryFactory;
    private final GroupOfLinesType groupOfLinesTypeFactory;
    private final DatedServiceJourneyQuery datedServiceJourneyQueryFactory;
    private final Relay relay = new Relay();

    public TransmodelGraphQLSchemaFactory(RouteRequest defaultRequest, ZoneId timeZoneId, TransitTuningParameters transitTuningParameters, FeedScopedIdMapper idMapper, ApiDocumentationProfile docProfile) {
        this.timeZoneId = timeZoneId;
        this.routing = new DefaultRouteRequestType(defaultRequest);
        this.transitTuningParameters = transitTuningParameters;
        this.idMapper = idMapper;
        this.docProfile = docProfile;
        this.authorityTypeFactory = new AuthorityType(idMapper);
        this.operatorTypeFactory = new OperatorType(idMapper);
        this.brandingTypeFactory = new BrandingType(idMapper);
        this.noticeTypeFactory = new NoticeType(idMapper);
        this.tariffZoneTypeFactory = new TariffZoneType(idMapper);
        this.bikeParkTypeFactory = new BikeParkType(idMapper);
        this.stopPlaceTypeFactory = new StopPlaceType(idMapper);
        this.quayTypeFactory = new QuayType(idMapper);
        this.quayAtDistanceTypeFactory = new QuayAtDistanceType(idMapper);
        this.lineTypeFactory = new LineType(idMapper);
        this.journeyPatternTypeFactory = new JourneyPatternType(idMapper);
        this.serviceJourneyTypeFactory = new ServiceJourneyType(idMapper);
        this.datedServiceJourneyTypeFactory = new DatedServiceJourneyType(idMapper);
        this.tripQueryFactory = new TripQuery(idMapper);
        this.viaTripQueryFactory = new ViaTripQuery(idMapper);
        this.groupOfLinesTypeFactory = new GroupOfLinesType(idMapper);
        this.datedServiceJourneyQueryFactory = new DatedServiceJourneyQuery(idMapper);
    }

    public GraphQLSchema create() {
        GraphQLSchema schema = this.createDefault();
        schema = TransmodelGraphQLSchemaFactory.decorateSchemaWithCustomDocumentation(schema, this.docProfile);
        return schema;
    }

    private GraphQLSchema createDefault() {
        GraphQLScalarType dateTimeScalar = DateTimeScalarFactory.createMillisecondsSinceEpochAsDateTimeStringScalar(this.timeZoneId);
        GraphQLObjectType multilingualStringType = MultilingualStringType.create();
        GraphQLObjectType validityPeriodType = ValidityPeriodType.create(dateTimeScalar);
        GraphQLObjectType infoLinkType = InfoLinkType.create();
        GraphQLObjectType bookingArrangementType = BookingArrangementType.create();
        GraphQLObjectType systemNoticeType = SystemNoticeType.create();
        GraphQLObjectType linkGeometryType = PointsOnLinkType.create();
        GraphQLOutputType serverInfoType = ServerInfoType.create();
        GraphQLObjectType authorityType = this.authorityTypeFactory.create((GraphQLOutputType)LineType.REF, (GraphQLOutputType)PtSituationElementType.REF);
        GraphQLObjectType operatorType = this.operatorTypeFactory.create((GraphQLOutputType)LineType.REF, (GraphQLOutputType)ServiceJourneyType.REF);
        GraphQLObjectType brandingType = this.brandingTypeFactory.create();
        GraphQLObjectType noticeType = this.noticeTypeFactory.create();
        GraphQLObjectType rentalVehicleTypeType = RentalVehicleTypeType.create();
        GraphQLObjectType tariffZoneType = this.tariffZoneTypeFactory.createTZ();
        GraphQLInterfaceType placeInterface = PlaceInterfaceType.create();
        GraphQLObjectType bikeRentalStationType = BikeRentalStationType.create(placeInterface);
        GraphQLObjectType rentalVehicleType = RentalVehicleType.create((GraphQLOutputType)rentalVehicleTypeType, placeInterface);
        GraphQLObjectType bikeParkType = this.bikeParkTypeFactory.createB(placeInterface);
        GraphQLObjectType stopPlaceType = this.stopPlaceTypeFactory.create(placeInterface, QuayType.REF, (GraphQLOutputType)tariffZoneType, (GraphQLOutputType)EstimatedCallType.REF, (GraphQLOutputType)PtSituationElementType.REF, dateTimeScalar);
        GraphQLObjectType quayType = this.quayTypeFactory.create(placeInterface, (GraphQLOutputType)stopPlaceType, (GraphQLOutputType)LineType.REF, (GraphQLOutputType)JourneyPatternType.REF, (GraphQLOutputType)EstimatedCallType.REF, (GraphQLOutputType)PtSituationElementType.REF, (GraphQLOutputType)tariffZoneType, dateTimeScalar);
        GraphQLObjectType stopToStopGeometryType = StopToStopGeometryType.create((GraphQLOutputType)linkGeometryType, (GraphQLOutputType)quayType);
        GraphQLObjectType quayAtDistance = this.quayAtDistanceTypeFactory.createQD((GraphQLOutputType)quayType, this.relay);
        GraphQLObjectType placeAtDistanceType = PlaceAtDistanceType.create(this.relay, placeInterface);
        GraphQLObjectType presentationType = PresentationType.create();
        GraphQLObjectType groupOfLinesType = this.groupOfLinesTypeFactory.create();
        GraphQLObjectType destinationDisplayType = DestinationDisplayType.create();
        GraphQLObjectType lineType = this.lineTypeFactory.create((GraphQLOutputType)bookingArrangementType, (GraphQLOutputType)authorityType, (GraphQLOutputType)operatorType, (GraphQLOutputType)noticeType, (GraphQLOutputType)quayType, presentationType, (GraphQLOutputType)JourneyPatternType.REF, (GraphQLOutputType)ServiceJourneyType.REF, (GraphQLOutputType)PtSituationElementType.REF, (GraphQLOutputType)brandingType, (GraphQLOutputType)groupOfLinesType);
        GraphQLObjectType interchangeType = InterchangeType.create((GraphQLOutputType)lineType, (GraphQLOutputType)ServiceJourneyType.REF);
        GraphQLOutputType affectsType = AffectsType.create((GraphQLOutputType)quayType, (GraphQLOutputType)stopPlaceType, (GraphQLOutputType)lineType, (GraphQLOutputType)ServiceJourneyType.REF, (GraphQLOutputType)DatedServiceJourneyType.REF);
        GraphQLObjectType ptSituationElementType = PtSituationElementType.create((GraphQLOutputType)authorityType, (GraphQLOutputType)quayType, (GraphQLOutputType)stopPlaceType, (GraphQLOutputType)lineType, (GraphQLOutputType)ServiceJourneyType.REF, (GraphQLOutputType)multilingualStringType, validityPeriodType, infoLinkType, affectsType, dateTimeScalar, this.relay);
        GraphQLObjectType journeyPatternType = this.journeyPatternTypeFactory.create((GraphQLOutputType)linkGeometryType, (GraphQLOutputType)noticeType, (GraphQLOutputType)quayType, (GraphQLOutputType)lineType, (GraphQLOutputType)ServiceJourneyType.REF, (GraphQLOutputType)stopToStopGeometryType, (GraphQLNamedOutputType)ptSituationElementType);
        GraphQLObjectType estimatedCallType = EstimatedCallType.create((GraphQLOutputType)bookingArrangementType, (GraphQLOutputType)noticeType, (GraphQLOutputType)quayType, (GraphQLOutputType)destinationDisplayType, (GraphQLOutputType)ptSituationElementType, (GraphQLOutputType)ServiceJourneyType.REF, (GraphQLOutputType)DatedServiceJourneyType.REF, dateTimeScalar);
        GraphQLObjectType serviceJourneyType = this.serviceJourneyTypeFactory.create((GraphQLOutputType)bookingArrangementType, (GraphQLOutputType)linkGeometryType, (GraphQLOutputType)operatorType, (GraphQLOutputType)noticeType, (GraphQLOutputType)quayType, (GraphQLOutputType)lineType, (GraphQLOutputType)ptSituationElementType, (GraphQLOutputType)journeyPatternType, (GraphQLOutputType)estimatedCallType, (GraphQLOutputType)TimetabledPassingTimeType.REF);
        GraphQLObjectType datedServiceJourneyType = this.datedServiceJourneyTypeFactory.create((GraphQLOutputType)serviceJourneyType, (GraphQLOutputType)journeyPatternType, (GraphQLType)estimatedCallType, (GraphQLType)quayType);
        GraphQLObjectType timetabledPassingTime = TimetabledPassingTimeType.create((GraphQLOutputType)bookingArrangementType, (GraphQLOutputType)noticeType, (GraphQLOutputType)quayType, (GraphQLOutputType)destinationDisplayType, (GraphQLOutputType)serviceJourneyType);
        GraphQLObjectType tripPatternTimePenaltyType = TripPatternTimePenaltyType.create();
        GraphQLObjectType tripMetadataType = TripMetadataType.create(dateTimeScalar);
        GraphQLObjectType placeType = PlanPlaceType.create((GraphQLOutputType)bikeRentalStationType, (GraphQLOutputType)rentalVehicleType, (GraphQLOutputType)quayType);
        GraphQLObjectType elevationStepType = ElevationProfileStepType.create();
        GraphQLObjectType emissionType = EmissionType.create();
        GraphQLObjectType pathGuidanceType = PathGuidanceType.create(elevationStepType);
        GraphQLObjectType legType = LegType.create((GraphQLOutputType)bookingArrangementType, (GraphQLOutputType)interchangeType, (GraphQLOutputType)linkGeometryType, (GraphQLOutputType)authorityType, (GraphQLOutputType)operatorType, (GraphQLOutputType)quayType, (GraphQLOutputType)estimatedCallType, (GraphQLOutputType)lineType, (GraphQLOutputType)serviceJourneyType, (GraphQLOutputType)datedServiceJourneyType, (GraphQLOutputType)ptSituationElementType, placeType, pathGuidanceType, (GraphQLType)elevationStepType, emissionType, dateTimeScalar);
        GraphQLObjectType tripPatternType = TripPatternType.create((GraphQLOutputType)systemNoticeType, legType, tripPatternTimePenaltyType, emissionType, dateTimeScalar);
        GraphQLObjectType routingErrorType = RoutingErrorType.create();
        GraphQLObjectType tripType = TripType.create(placeType, tripPatternType, tripMetadataType, routingErrorType, dateTimeScalar);
        GraphQLInputObjectType durationPerStreetModeInput = StreetModeDurationInputType.create();
        GraphQLInputObjectType penaltyForStreetMode = PenaltyForStreetModeType.create();
        GraphQLFieldDefinition tripQuery = this.tripQueryFactory.create(this.routing, this.transitTuningParameters, (GraphQLOutputType)tripType, durationPerStreetModeInput, penaltyForStreetMode, dateTimeScalar);
        GraphQLOutputType viaTripType = ViaTripType.create(tripPatternType, routingErrorType);
        GraphQLInputObjectType viaLocationInputType = ViaLocationInputType.create();
        GraphQLInputObjectType viaSegmentInputType = ViaSegmentInputType.create();
        GraphQLFieldDefinition viaTripQuery = this.viaTripQueryFactory.create(this.routing, viaTripType, viaLocationInputType, viaSegmentInputType, dateTimeScalar);
        GraphQLInputObjectType inputPlaceIds = GraphQLInputObjectType.newInputObject().name("InputPlaceIds").field(GraphQLInputObjectField.newInputObjectField().name("quays").description("Quays to include by id.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).field(GraphQLInputObjectField.newInputObjectField().name("lines").description("Lines to include by id.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).field(GraphQLInputObjectField.newInputObjectField().name("bikeRentalStations").description("Bike rentals to include by id.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).field(GraphQLInputObjectField.newInputObjectField().name("bikeParks").description("Bike parks to include by id.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).field(GraphQLInputObjectField.newInputObjectField().name("carParks").description("Car parks to include by id.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).build();
        GraphQLObjectType queryType = GraphQLObjectType.newObject().name("QueryType").field(tripQuery).field(viaTripQuery).field(GraphQLFieldDefinition.newFieldDefinition().name("stopPlace").description("Get a single stopPlace based on its id)").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)stopPlaceType).argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build()).dataFetcher(env -> StopPlaceType.fetchStopPlaceById(this.idMapper.parseNullSafe((String)env.getArgument("id")).orElse(null), env)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("stopPlaces").description("Get all stopPlaces").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)stopPlaceType))).argument(GraphQLArgument.newArgument().name("ids").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).dataFetcher(env -> {
            if (env.getArgument("ids") != null) {
                return this.resolveIds(env).map(id -> StopPlaceType.fetchStopPlaceById(id, env)).collect(Collectors.toList());
            }
            TransitService transitService = GqlUtil.getTransitService(env);
            return transitService.listStations().stream().map(station -> new MonoOrMultiModalStation((Station)station, transitService.findMultiModalStation((Station)station))).collect(Collectors.toList());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("stopPlacesByBbox").description("Get all stop places within the specified bounding box").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)stopPlaceType))).argument(GraphQLArgument.newArgument().name("minimumLatitude").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("minimumLongitude").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("maximumLatitude").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("maximumLongitude").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("authority").type((GraphQLInputType)Scalars.GraphQLString).build()).argument(GraphQLArgument.newArgument().name("multiModalMode").type((GraphQLInputType)EnumTypes.MULTI_MODAL_MODE).description("MultiModalMode for query. To control whether multi modal parent stop places, their mono modal children or both are included in the response. Does not affect mono modal stop places that do not belong to a multi modal stop place.").defaultValue((Object)"parent").build()).argument(GraphQLArgument.newArgument().name("filterByInUse").description("If true only stop places with at least one visiting line are included.").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValue((Object)Boolean.FALSE).build()).dataFetcher(env -> {
            double minLat = (Double)env.getArgument("minimumLatitude");
            double minLon = (Double)env.getArgument("minimumLongitude");
            double maxLat = (Double)env.getArgument("maximumLatitude");
            double maxLon = (Double)env.getArgument("maximumLongitude");
            String authority = (String)env.getArgument("authority");
            boolean filterByInUse = Boolean.TRUE.equals(env.getArgument("filterByInUse"));
            String multiModalMode = (String)env.getArgument("multiModalMode");
            return StopPlaceType.fetchStopPlaces(minLat, minLon, maxLat, maxLon, authority, filterByInUse, multiModalMode, env);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("quay").description("Get a single quay based on its id)").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)quayType).argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build()).dataFetcher(environment -> GqlUtil.getTransitService(environment).getStopLocation(this.idMapper.parseNullSafe((String)environment.getArgument("id")).orElse(null))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("quays").description("Get all quays").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)quayType))).argument(GraphQLArgument.newArgument().name("ids").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).argument(GraphQLArgument.newArgument().name("name").type((GraphQLInputType)Scalars.GraphQLString).build()).dataFetcher(environment -> {
            if (environment.containsArgument("ids")) {
                Stream<FeedScopedId> ids = this.resolveIds(environment);
                if (environment.getArgument("name") != null) {
                    throw new IllegalArgumentException("Unable to combine other filters with ids");
                }
                TransitService transitService = GqlUtil.getTransitService(environment);
                return ids.map(transitService::getStopLocation).toList();
            }
            FindStopLocationsRequest request = FindStopLocationsRequest.of().withName((String)environment.getArgument("name")).build();
            return GqlUtil.getTransitService(environment).findStopLocations(request);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("quaysByBbox").description("Get all quays within the specified bounding box").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)quayType))).argument(GraphQLArgument.newArgument().name("minimumLatitude").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("minimumLongitude").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("maximumLatitude").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("maximumLongitude").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("authority").deprecate("This is the Transmodel namespace or the GTFS feedID - avoid using this. Request a new field if necessary.").type((GraphQLInputType)Scalars.GraphQLString).build()).argument(GraphQLArgument.newArgument().name("filterByInUse").description("If true only quays with at least one visiting line are included.").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValueProgrammatic((Object)Boolean.FALSE).build()).dataFetcher(environment -> {
            Envelope envelope = new Envelope(new Coordinate(((Double)environment.getArgument("minimumLongitude")).doubleValue(), ((Double)environment.getArgument("minimumLatitude")).doubleValue()), new Coordinate(((Double)environment.getArgument("maximumLongitude")).doubleValue(), ((Double)environment.getArgument("maximumLatitude")).doubleValue()));
            String authority = (String)environment.getArgument("authority");
            Boolean filterInUse = (Boolean)environment.getArgument("filterByInUse");
            FindRegularStopsByBoundingBoxRequest findRegularStopsByBoundingBoxRequest = FindRegularStopsByBoundingBoxRequest.of(envelope).withFeedId(authority).filterByInUse(filterInUse).build();
            return GqlUtil.getTransitService(environment).findRegularStopsByBoundingBox(findRegularStopsByBoundingBoxRequest);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("quaysByRadius").description("Get all quays within the specified walking radius from a location. There are no maximum limits for the input parameters, but the query will timeout and return if the parameters are too high.").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)this.relay.connectionType("quayAtDistance", this.relay.edgeType("quayAtDistance", (GraphQLOutputType)quayAtDistance, null, new ArrayList()), new ArrayList())).argument(GraphQLArgument.newArgument().name("latitude").description("Latitude of the location").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("longitude").description("Longitude of the location").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("radius").description("Radius via streets (in meters) to search for from the specified location").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("authority").type((GraphQLInputType)Scalars.GraphQLString).build()).arguments(this.relay.getConnectionFieldArguments()).dataFetcher(environment -> {
            List<Object> stops;
            try {
                stops = GqlUtil.getGraphFinder(environment).findClosestStops(new Coordinate(((Double)environment.getArgument("longitude")).doubleValue(), ((Double)environment.getArgument("latitude")).doubleValue()), (Double)environment.getArgument("radius")).stream().filter(stopAtDistance -> environment.getArgument("authority") == null || stopAtDistance.stop.getId().getFeedId().equalsIgnoreCase((String)environment.getArgument("authority"))).sorted(Comparator.comparing(s -> s.distance)).collect(Collectors.toList());
            }
            catch (RoutingValidationException e) {
                LOG.warn("findClosestPlacesByWalking failed with exception, returning empty list of places. ", (Throwable)e);
                stops = List.of();
            }
            if (stops.isEmpty()) {
                return new DefaultConnection(Collections.emptyList(), (PageInfo)new DefaultPageInfo(null, null, false, false));
            }
            return new SimpleListConnection(stops).get(environment);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("nearest").description("Get all places (quays, stop places, car parks etc. with coordinates) within the specified radius from a location. The returned type has two fields place and distance. The search is done by walking so the distance is according to the network of walkables.").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)this.relay.connectionType("placeAtDistance", this.relay.edgeType("placeAtDistance", (GraphQLOutputType)placeAtDistanceType, null, new ArrayList()), new ArrayList())).argument(GraphQLArgument.newArgument().name("latitude").description("Latitude of the location").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("longitude").description("Longitude of the location").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("maximumDistance").description("Maximum distance (in meters) to search for from the specified location. Default is 2000m.").defaultValueProgrammatic((Object)2000).type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLFloat)).build()).argument(GraphQLArgument.newArgument().name("maximumResults").description("Maximum number of results. Search is stopped when this limit is reached. Default is 20.").defaultValue((Object)20).type((GraphQLInputType)Scalars.GraphQLInt).build()).argument(GraphQLArgument.newArgument().name("filterByPlaceTypes").description("Only include places of given types if set. Default accepts all types").defaultValue(Arrays.asList(TransmodelPlaceType.values())).type((GraphQLInputType)new GraphQLList((GraphQLType)EnumTypes.FILTER_PLACE_TYPE_ENUM)).build()).argument(GraphQLArgument.newArgument().name("filterByModes").description("Only include places that include this mode. Only checked for places with mode i.e. quays, departures.").type((GraphQLInputType)new GraphQLList((GraphQLType)EnumTypes.TRANSPORT_MODE)).build()).argument(GraphQLArgument.newArgument().name("filterByInUse").description("Only affects queries for quays and stop places. If true only quays and stop places with at least one visiting line are included.").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValue((Object)Boolean.FALSE).build()).argument(GraphQLArgument.newArgument().name("filterByIds").description("Only include places that match one of the given ids.").type((GraphQLInputType)inputPlaceIds).build()).argument(GraphQLArgument.newArgument().name("multiModalMode").type((GraphQLInputType)EnumTypes.MULTI_MODAL_MODE).description("MultiModalMode for query. To control whether multi modal parent stop places, their mono modal children or both are included in the response. Does not affect mono modal stop places that do not belong to a multi modal stop place. Only applicable for placeType StopPlace").defaultValue((Object)"parent").build()).argument(this.relay.getConnectionFieldArguments()).dataFetcher(environment -> {
            int orgMaxResults;
            List<FeedScopedId> filterByStops = null;
            List<FeedScopedId> filterByStations = null;
            List<FeedScopedId> filterByRoutes = null;
            List filterByBikeRentalStations = null;
            List filterByBikeParks = null;
            List filterByCarParks = null;
            List<String> filterByNetwork = null;
            Map filterByIds = (Map)environment.getArgument("filterByIds");
            if (filterByIds != null) {
                filterByStops = this.idMapper.parseListNullSafe((List)filterByIds.get("quays"));
                filterByRoutes = this.idMapper.parseListNullSafe((List)filterByIds.get("lines"));
                filterByBikeRentalStations = filterByIds.get("bikeRentalStations") != null ? (List)filterByIds.get("bikeRentalStations") : List.of();
                filterByBikeParks = filterByIds.get("bikeParks") != null ? (List)filterByIds.get("bikeParks") : List.of();
                filterByCarParks = filterByIds.get("carParks") != null ? (List)filterByIds.get("carParks") : List.of();
            }
            List filterByTransportModes = (List)environment.getArgument("filterByModes");
            List<TransmodelPlaceType> placeTypes = (List<TransmodelPlaceType>)environment.getArgument("filterByPlaceTypes");
            if (placeTypes == null || placeTypes.isEmpty()) {
                placeTypes = Arrays.asList(TransmodelPlaceType.values());
            }
            List<PlaceType> filterByPlaceTypes = PlaceMapper.mapToDomain(placeTypes);
            int maxResults = orgMaxResults = ((Integer)environment.getArgument("maximumResults")).intValue();
            if (placeTypes.contains((Object)TransmodelPlaceType.STOP_PLACE)) {
                maxResults *= 5;
            }
            List<PlaceAtDistance> places = GqlUtil.getGraphFinder(environment).findClosestPlaces((Double)environment.getArgument("latitude"), (Double)environment.getArgument("longitude"), (Double)environment.getArgument("maximumDistance"), maxResults, filterByTransportModes, filterByPlaceTypes, filterByStops, filterByStations, filterByRoutes, filterByBikeRentalStations, filterByNetwork, GqlUtil.getTransitService(environment));
            if (Boolean.TRUE.equals(environment.getArgument("filterByInUse"))) {
                places = places.stream().filter(placeAtDistance -> {
                    Object patt0$temp = placeAtDistance.place();
                    if (patt0$temp instanceof StopLocation) {
                        StopLocation stop = (StopLocation)patt0$temp;
                        return !GqlUtil.getTransitService(environment).findPatterns(stop, true).isEmpty();
                    }
                    return true;
                }).toList();
            }
            if ((places = PlaceAtDistanceType.convertQuaysToStopPlaces(placeTypes, places, (String)environment.getArgument("multiModalMode"), GqlUtil.getTransitService(environment)).stream().limit(orgMaxResults).collect(Collectors.toList())).isEmpty()) {
                return new DefaultConnection(List.of(), (PageInfo)new DefaultPageInfo(null, null, false, false));
            }
            return new SimpleListConnection(places).get(environment);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("authority").description("Get an authority by ID").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)authorityType).argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build()).dataFetcher(environment -> GqlUtil.getTransitService(environment).getAgency(this.idMapper.parseNullSafe((String)environment.getArgument("id")).orElse(null))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("authorities").description("Get all authorities").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)authorityType))).dataFetcher(environment -> new ArrayList<Agency>(GqlUtil.getTransitService(environment).listAgencies())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("operator").description("Get a operator by ID").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)operatorType).argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build()).dataFetcher(environment -> GqlUtil.getTransitService(environment).getOperator(this.idMapper.parseNullSafe((String)environment.getArgument("id")).orElse(null))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("operators").description("Get all operators").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)operatorType))).dataFetcher(environment -> new ArrayList<Operator>(GqlUtil.getTransitService(environment).listOperators())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("line").description("Get a single line based on its id").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)lineType).argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLID)).build()).dataFetcher(environment -> {
            String id = (String)environment.getArgument("id");
            return GqlUtil.getTransitService(environment).getRoute(this.idMapper.parseNullSafe(id).orElse(null));
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("lines").description("Get all _lines_").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)lineType))).argument(GraphQLArgument.newArgument().name("ids").description("Set of ids of _lines_ to fetch. If this is set, no other filters can be set.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLID)).build()).argument(GraphQLArgument.newArgument().name("name").description("Prefix of the _name_ of the _line_ to fetch. This filter is case insensitive.").type((GraphQLInputType)Scalars.GraphQLString).build()).argument(GraphQLArgument.newArgument().name("publicCode").description("_Public code_ of the _line_ to fetch.").type((GraphQLInputType)Scalars.GraphQLString).build()).argument(GraphQLArgument.newArgument().name("publicCodes").description("Set of _public codes_ to fetch _lines_ for.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).argument(GraphQLArgument.newArgument().name("transportModes").description("Set of _transport modes_ to fetch _lines_ for.").type((GraphQLInputType)new GraphQLList((GraphQLType)EnumTypes.TRANSPORT_MODE)).build()).argument(GraphQLArgument.newArgument().name("authorities").description("Set of ids of _authorities_ to fetch _lines_ for.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).argument(GraphQLArgument.newArgument().name("flexibleOnly").description("Filter by _lines_ containing flexible / on demand _service journey_ only.").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValueProgrammatic((Object)false).build()).dataFetcher(environment -> {
            if (environment.containsArgument("ids")) {
                List<FeedScopedId> ids = this.idMapper.parseListNullSafe((Collection)environment.getArgument("ids"));
                if (Stream.of("name", "publicCode", "publicCodes", "transportModes", "authorities").anyMatch(arg_0 -> ((DataFetchingEnvironment)environment).containsArgument(arg_0)) || Boolean.TRUE.equals(environment.getArgument("flexibleOnly"))) {
                    throw new IllegalArgumentException("Unable to combine other filters with ids");
                }
                return GqlUtil.getTransitService(environment).getRoutes(ids);
            }
            String name = (String)environment.getArgument("name");
            String publicCode = (String)environment.getArgument("publicCode");
            FilterValues<String> publicCodes = FilterValues.ofEmptyIsEverything("publicCodes", (Collection)environment.getArgument("publicCodes"));
            FilterValues<TransitMode> transportModes = FilterValues.ofEmptyIsEverything("transportModes", (Collection)environment.getArgument("transportModes"));
            FilterValues<String> authorities = FilterValues.ofEmptyIsEverything("authorities", (Collection)environment.getArgument("authorities"));
            boolean flexibleOnly = Boolean.TRUE.equals(environment.getArgument("flexibleOnly"));
            FindRoutesRequest findRoutesRequest = FindRoutesRequest.of().withLongName(name).withShortName(publicCode).withShortNames(publicCodes).withTransitModes(transportModes).withAgencies(authorities).withFlexibleOnly(flexibleOnly).build();
            return GqlUtil.getTransitService(environment).findRoutes(findRoutesRequest);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("groupOfLines").description("Get a single group of lines based on its id").type((GraphQLOutputType)groupOfLinesType).argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build()).dataFetcher(environment -> GqlUtil.getTransitService(environment).getGroupOfRoutes(this.idMapper.parseNullSafe((String)environment.getArgument("id")).orElse(null))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("groupsOfLines").description("Get all groups of lines").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)groupOfLinesType)))).dataFetcher(environment -> GqlUtil.getTransitService(environment).listGroupsOfRoutes()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("serviceJourney").description("Get a single service journey based on its id").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)serviceJourneyType).argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build()).dataFetcher(environment -> GqlUtil.getTransitService(environment).getTrip(this.idMapper.parseNullSafe((String)environment.getArgument("id")).orElse(null))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("serviceJourneys").description("Get all _service journeys_").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)serviceJourneyType))).argument(GraphQLArgument.newArgument().name("lines").description("Set of ids of _lines_ to fetch _service journeys_ for.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLID)).build()).argument(GraphQLArgument.newArgument().name("privateCodes").description("Set of ids of _private codes_ to fetch _service journeys_ for.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).argument(GraphQLArgument.newArgument().name("activeDates").description("Set of _operating days_ to fetch _service journeys_ for.").type((GraphQLInputType)new GraphQLList((GraphQLType)TransmodelScalars.DATE_SCALAR)).build()).argument(GraphQLArgument.newArgument().name("authorities").description("Set of ids of _authorities_ to fetch _service journeys_ for.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).dataFetcher(environment -> {
            TripRequest tripRequest = TripRequest.of().withIncludeAgencies(this.toNullableIdList((List)environment.getArgument("authorities"))).withIncludeRoutes(this.toNullableIdList((List)environment.getArgument("lines"))).withIncludeNetexInternalPlanningCodes((List)environment.getArgument("privateCodes")).withIncludeServiceDates((List)environment.getArgument("activeDates")).build();
            return GqlUtil.getTransitService(environment).getTrips(tripRequest);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikeRentalStations").description("Get all bike rental stations").withDirective(TransmodelDirectives.TIMING_DATA).argument(GraphQLArgument.newArgument().name("ids").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)bikeRentalStationType))).dataFetcher(environment -> {
            ArrayList<VehicleRentalStation> all = new ArrayList<VehicleRentalStation>(GqlUtil.getVehicleRentalService(environment).getVehicleRentalStations());
            List filterByIds = (List)environment.getArgument("ids");
            if (filterByIds != null && !filterByIds.isEmpty()) {
                return all.stream().filter(station -> filterByIds.contains(station.stationId())).collect(Collectors.toList());
            }
            return all;
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikeRentalStation").description("Get all bike rental stations").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)bikeRentalStationType).argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build()).dataFetcher(environment -> GqlUtil.getVehicleRentalService(environment).getVehicleRentalStations().stream().filter(bikeRentalStation -> bikeRentalStation.stationId().equals(environment.getArgument("id"))).findFirst().orElse(null)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikeRentalStationsByBbox").description("Get all bike rental stations within the specified bounding box.").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)bikeRentalStationType))).argument(GraphQLArgument.newArgument().name("minimumLatitude").type((GraphQLInputType)Scalars.GraphQLFloat).build()).argument(GraphQLArgument.newArgument().name("minimumLongitude").type((GraphQLInputType)Scalars.GraphQLFloat).build()).argument(GraphQLArgument.newArgument().name("maximumLatitude").type((GraphQLInputType)Scalars.GraphQLFloat).build()).argument(GraphQLArgument.newArgument().name("maximumLongitude").type((GraphQLInputType)Scalars.GraphQLFloat).build()).dataFetcher(environment -> GqlUtil.getVehicleRentalService(environment).getVehicleRentalStationForEnvelope((Double)environment.getArgument("minimumLongitude"), (Double)environment.getArgument("minimumLatitude"), (Double)environment.getArgument("maximumLongitude"), (Double)environment.getArgument("maximumLatitude"))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikePark").description("Get a single bike park based on its id").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)bikeParkType).argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build()).dataFetcher(environment -> {
            Optional<FeedScopedId> bikeParkId = this.idMapper.parseNullSafe((String)environment.getArgument("id"));
            return GqlUtil.getVehicleParkingService(environment).listBikeParks().stream().filter(bikePark -> bikePark.getId().equals(bikeParkId)).findFirst().orElse(null);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bikeParks").description("Get all bike parks").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)bikeParkType))).dataFetcher(environment -> GqlUtil.getVehicleParkingService(environment).listBikeParks().stream().collect(Collectors.toCollection(ArrayList::new))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("routingParameters").description("Get default routing parameters.").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)this.routing.graphQLType).dataFetcher(environment -> this.routing.request).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("situations").description("Get all active situations.").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)ptSituationElementType)))).argument(GraphQLArgument.newArgument().name("authorities").description("Filter by reporting authorities.").deprecate("Use codespaces instead. This only uses the codespace of the given authority.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).argument(GraphQLArgument.newArgument().name("codespaces").description("Filter by reporting source.").type((GraphQLInputType)new GraphQLList((GraphQLType)Scalars.GraphQLString)).build()).argument(GraphQLArgument.newArgument().name("severities").description("Filter by severity.").type((GraphQLInputType)new GraphQLList((GraphQLType)EnumTypes.SEVERITY)).build()).dataFetcher(environment -> {
            Collection alerts = GqlUtil.getTransitService(environment).getTransitAlertService().getAllAlerts();
            HashSet codespaces = new HashSet();
            if (environment.getArgument("authorities") instanceof List) {
                List authorities = (List)environment.getArgument("authorities");
                authorities.stream().map(authority -> authority.split(":")[0]).filter(Objects::nonNull).filter(Predicate.not(String::isBlank)).forEach(codespaces::add);
            }
            if (environment.getArgument("codespaces") instanceof List) {
                codespaces.addAll((Collection)environment.getArgument("codespaces"));
            }
            if (!codespaces.isEmpty()) {
                alerts = alerts.stream().filter(alert -> codespaces.contains(alert.siriCodespace())).collect(Collectors.toSet());
            }
            if (environment.getArgument("severities") instanceof List) {
                List severities = (List)environment.getArgument("severities");
                alerts = alerts.stream().filter(alert -> severities.contains(SeverityMapper.getTransmodelSeverity(alert.severity()))).collect(Collectors.toSet());
            }
            return alerts;
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("situation").description("Get a single situation based on its situationNumber").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)ptSituationElementType).argument(GraphQLArgument.newArgument().name("situationNumber").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build()).dataFetcher(environment -> {
            String situationNumber = (String)environment.getArgument("situationNumber");
            if (situationNumber.isBlank()) {
                return null;
            }
            return GqlUtil.getTransitService(environment).getTransitAlertService().getAlertById(this.idMapper.parseNullSafe(situationNumber).orElse(null));
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("leg").description("Refetch a single transit leg based on its id").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)LegType.REF).argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLID)).build()).dataFetcher(environment -> {
            String id = (String)environment.getArgument("id");
            if (id.isBlank()) {
                return null;
            }
            LegReference ref = LegReferenceSerializer.decode(id);
            if (ref == null) {
                return null;
            }
            return ref.getLeg(GqlUtil.getTransitService(environment));
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("serverInfo").description("Get OTP deployment information. This is only useful for developers of OTP itself not regular API users.").withDirective(TransmodelDirectives.TIMING_DATA).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)serverInfoType)).dataFetcher(e -> OtpProjectInfo.projectInfo()).build()).field(this.datedServiceJourneyQueryFactory.createGetById((GraphQLOutputType)datedServiceJourneyType)).field(this.datedServiceJourneyQueryFactory.createQuery((GraphQLOutputType)datedServiceJourneyType)).build();
        return GraphQLSchema.newSchema().query(queryType).additionalType((GraphQLType)placeInterface).additionalType((GraphQLType)timetabledPassingTime).additionalType((GraphQLType)Relay.pageInfoType).additionalDirective(TransmodelDirectives.TIMING_DATA).build();
    }

    private static GraphQLSchema decorateSchemaWithCustomDocumentation(GraphQLSchema schema, ApiDocumentationProfile docProfile) {
        CustomDocumentation customDocumentation = CustomDocumentation.of(docProfile);
        if (customDocumentation.isEmpty()) {
            return schema;
        }
        InjectCustomDocumentation visitor = new InjectCustomDocumentation(customDocumentation);
        return SchemaTransformer.transformSchema((GraphQLSchema)schema, (GraphQLTypeVisitor)visitor);
    }

    private Stream<FeedScopedId> resolveIds(DataFetchingEnvironment env) {
        return Optional.ofNullable((Collection)env.getArgument("ids")).stream().flatMap(ids -> ids.stream().filter(StringUtils::hasValue).map(this.idMapper::parse));
    }

    @Nullable
    private List<FeedScopedId> toNullableIdList(@Nullable List<String> ids) {
        if (ids == null) {
            return null;
        }
        return this.idMapper.parseList(ids);
    }
}

