/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionStrategy;
import graphql.execution.UnknownOperationException;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.schema.CoercingParseValueException;
import graphql.schema.GraphQLSchema;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.opentripplanner.apis.support.graphql.LoggingDataFetcherExceptionHandler;
import org.opentripplanner.apis.transmodel.MaxFieldsInResultInstrumentation;
import org.opentripplanner.apis.transmodel.ResponseTooLargeException;
import org.opentripplanner.apis.transmodel.TransmodelRequestContext;
import org.opentripplanner.apis.transmodel.support.AbortOnUnprocessableRequestExecutionStrategy;
import org.opentripplanner.apis.transmodel.support.ExecutionResultMapper;
import org.opentripplanner.ext.actuator.MicrometerGraphQLInstrumentation;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.framework.application.OTPRequestTimeoutException;
import org.opentripplanner.framework.concurrent.OtpRequestThreadFactory;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.transit.model.framework.EntityNotFoundException;
import org.opentripplanner.utils.lang.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransmodelGraph {
    private static final Logger LOG = LoggerFactory.getLogger(TransmodelGraph.class);
    private static final int MAX_ERROR_TO_RETURN = 25;
    private final GraphQLSchema indexSchema;
    final ExecutorService threadPool = Executors.newCachedThreadPool(OtpRequestThreadFactory.of("transmodel-api-%d"));

    TransmodelGraph(GraphQLSchema schema) {
        this.indexSchema = schema;
    }

    Response executeGraphQL(String query, OtpServerRequestContext serverContext, Map<String, Object> variables, String operationName, int maxNumberOfResultFields, Iterable<Tag> tracingTags) {
        AbortOnUnprocessableRequestExecutionStrategy executionStrategy = new AbortOnUnprocessableRequestExecutionStrategy();
        try {
            variables = (Map)ObjectUtils.ifNotNull(variables, new HashMap());
            Instrumentation instrumentation = TransmodelGraph.createInstrumentation(maxNumberOfResultFields, tracingTags);
            TransmodelRequestContext transmodelRequestContext = TransmodelGraph.createRequestContext(serverContext);
            ExecutionInput executionInput = TransmodelGraph.createExecutionInput(query, serverContext, variables, operationName, transmodelRequestContext);
            GraphQL graphQL = this.createGraphQL(instrumentation, (ExecutionStrategy)executionStrategy);
            ExecutionResult result = graphQL.execute(executionInput);
            result = TransmodelGraph.limitMaxNumberOfErrors(result);
            Response response = ExecutionResultMapper.okResponse(result);
            executionStrategy.close();
            return response;
        }
        catch (Throwable throwable) {
            try {
                try {
                    executionStrategy.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (OTPRequestTimeoutException te) {
                return ExecutionResultMapper.timeoutResponse();
            }
            catch (ResponseTooLargeException rtle) {
                return ExecutionResultMapper.tooLargeResponse(rtle.getMessage());
            }
            catch (UnknownOperationException | CoercingParseValueException | EntityNotFoundException e) {
                return ExecutionResultMapper.badRequestResponse(e.getMessage());
            }
            catch (Exception systemError) {
                LOG.error(systemError.getMessage(), (Throwable)systemError);
                return ExecutionResultMapper.systemErrorResponse(systemError.getMessage());
            }
        }
    }

    private static Instrumentation createInstrumentation(int maxNumberOfResultFields, Iterable<Tag> tracingTags) {
        MaxFieldsInResultInstrumentation instrumentation = new MaxFieldsInResultInstrumentation(maxNumberOfResultFields);
        if (OTPFeature.ActuatorAPI.isOn()) {
            instrumentation = new ChainedInstrumentation(new Instrumentation[]{new MicrometerGraphQLInstrumentation((MeterRegistry)Metrics.globalRegistry, tracingTags), instrumentation});
        }
        return instrumentation;
    }

    private static TransmodelRequestContext createRequestContext(OtpServerRequestContext serverContext) {
        return new TransmodelRequestContext(serverContext, serverContext.routingService(), serverContext.transitService());
    }

    private static ExecutionInput createExecutionInput(String query, OtpServerRequestContext serverContext, Map<String, Object> variables, String operationName, TransmodelRequestContext transmodelRequestContext) {
        return ExecutionInput.newExecutionInput().query(query).operationName(operationName).context((Object)transmodelRequestContext).root((Object)serverContext).variables(variables).build();
    }

    private GraphQL createGraphQL(Instrumentation instrumentation, ExecutionStrategy executionStrategy) {
        return GraphQL.newGraphQL((GraphQLSchema)this.indexSchema).instrumentation(instrumentation).queryExecutionStrategy(executionStrategy).defaultDataFetcherExceptionHandler((DataFetcherExceptionHandler)new LoggingDataFetcherExceptionHandler()).build();
    }

    private static ExecutionResult limitMaxNumberOfErrors(ExecutionResult result) {
        List errors = result.getErrors();
        if (errors.size() > 25) {
            List errorsShortList = errors.stream().limit(25L).toList();
            result = result.transform(b -> b.errors(errorsShortList));
        }
        return result;
    }
}

