/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.SchemaPrinter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opentripplanner.apis.support.TracingUtils;
import org.opentripplanner.apis.transmodel.TransmodelGraph;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/transmodel/v3")
@Produces(value={"application/json"})
public class TransmodelAPI {
    private static final String SCHEMA_DOC_HEADER = "# THIS IS NOT INTENDED FOR PRODUCTION USE. We recommend using the GraphQL introspection instead.\n# This is intended for the OTP Debug UI and can also be used by humans to get the schema with the\n# OTP configured default-values injected.\n\n";
    private static final Logger LOG = LoggerFactory.getLogger(TransmodelAPI.class);
    private final GraphQLSchema schema;
    private final Collection<String> tracingHeaderTags;
    private final int maxNumberOfResultFields;
    private final OtpServerRequestContext serverContext;
    private final TransmodelGraph index;
    private final ObjectMapper deserializer = new ObjectMapper();

    public TransmodelAPI(@Context OtpServerRequestContext serverContext) {
        this.serverContext = serverContext;
        this.schema = serverContext.transmodelSchema();
        this.index = new TransmodelGraph(this.schema);
        this.tracingHeaderTags = serverContext.transmodelAPIParameters().tracingHeaderTags();
        this.maxNumberOfResultFields = serverContext.transmodelAPIParameters().maxNumberOfResultFields();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response getGraphQL(HashMap<String, Object> queryParameters, @Context HttpHeaders headers) {
        String queryVariablesAsString;
        Map variables;
        if (queryParameters == null || !queryParameters.containsKey("query")) {
            LOG.debug("No query found in body");
            throw new BadRequestException("No query found in body");
        }
        Object object = queryParameters.get("query");
        if (!(object instanceof String)) {
            throw new BadRequestException("Invalid format for query");
        }
        String query = (String)object;
        Object queryVariables = queryParameters.getOrDefault("variables", null);
        if (queryVariables instanceof Map) {
            Map queryVariablesAsMap;
            variables = queryVariablesAsMap = (Map)queryVariables;
        } else if (queryVariables instanceof String && !(queryVariablesAsString = (String)queryVariables).isEmpty()) {
            try {
                variables = (Map)this.deserializer.readValue(queryVariablesAsString, Map.class);
            }
            catch (IOException e) {
                throw new BadRequestException("Variables must be a valid json object");
            }
        } else {
            variables = Collections.emptyMap();
        }
        String operationName = queryParameters.getOrDefault("operationName", null);
        return this.index.executeGraphQL(query, this.serverContext, variables, operationName, this.maxNumberOfResultFields, TracingUtils.findTagsInHeaders(this.tracingHeaderTags, headers));
    }

    @POST
    @Consumes(value={"application/graphql"})
    public Response getGraphQL(String query, @Context HttpHeaders headers) {
        return this.index.executeGraphQL(query, this.serverContext, null, null, this.maxNumberOfResultFields, TracingUtils.findTagsInHeaders(this.tracingHeaderTags, headers));
    }

    @GET
    @Path(value="schema.graphql")
    public Response getGraphQLSchema() {
        String text = SCHEMA_DOC_HEADER + new SchemaPrinter().print(this.schema);
        return Response.ok().encoding("UTF-8").entity((Object)text).build();
    }

    @Path(value="/routers/{ignoreRouterId}/transmodel/index/graphql")
    public static class TransmodelAPIOldPath
    extends TransmodelAPI {
        public TransmodelAPIOldPath(@Context OtpServerRequestContext serverContext, @PathParam(value="ignoreRouterId") String ignore) {
            super(serverContext);
        }
    }
}

