/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.transmodel;

import graphql.ExecutionResult;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import jakarta.validation.constraints.NotNull;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.opentripplanner.apis.transmodel.ResponseTooLargeException;
import org.opentripplanner.framework.application.OTPRequestTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxFieldsInResultInstrumentation
implements Instrumentation {
    private static final Logger LOG = LoggerFactory.getLogger(MaxFieldsInResultInstrumentation.class);
    private final int maxFieldFetch;
    private final AtomicLong fieldFetchCounter = new AtomicLong();

    public MaxFieldsInResultInstrumentation(int maxFieldFetch) {
        this.maxFieldFetch = maxFieldFetch;
    }

    public InstrumentationContext<Object> beginFieldFetch(InstrumentationFieldFetchParameters parameters, InstrumentationState state) {
        long fetched = this.fieldFetchCounter.incrementAndGet();
        if (fetched % 10000L == 0L) {
            LOG.debug("Fetched {} fields", (Object)fetched);
            if (fetched > (long)this.maxFieldFetch) {
                throw new ResponseTooLargeException("The number of fields in the GraphQL result exceeds the maximum allowed: " + this.maxFieldFetch);
            }
            OTPRequestTimeoutException.checkForTimeout();
        }
        return SimpleInstrumentationContext.noOp();
    }

    @NotNull
    public CompletableFuture<ExecutionResult> instrumentExecutionResult(ExecutionResult executionResult, InstrumentationExecutionParameters parameters, InstrumentationState state) {
        LOG.debug("The GraphQL result contains {} fields", (Object)this.fieldFetchCounter.get());
        return super.instrumentExecutionResult(executionResult, parameters, state);
    }
}

