/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.support.graphql.injectdoc;

import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.GraphQLUnionType;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.Optional;
import java.util.function.BiFunction;
import org.opentripplanner.apis.support.graphql.injectdoc.CustomDocumentation;

public class InjectCustomDocumentation
extends GraphQLTypeVisitorStub
implements GraphQLTypeVisitor {
    private final CustomDocumentation customDocumentation;

    public InjectCustomDocumentation(CustomDocumentation customDocumentation) {
        this.customDocumentation = customDocumentation;
    }

    public TraversalControl visitGraphQLScalarType(GraphQLScalarType scalar, TraverserContext<GraphQLSchemaElement> context) {
        return this.typeDoc(context, scalar, (s, doc) -> s.transform(b -> b.description(doc)));
    }

    public TraversalControl visitGraphQLInterfaceType(GraphQLInterfaceType interface_, TraverserContext<GraphQLSchemaElement> context) {
        return this.typeDoc(context, interface_, (f, doc) -> f.transform(b -> b.description(doc)));
    }

    public TraversalControl visitGraphQLEnumType(GraphQLEnumType enumType, TraverserContext<GraphQLSchemaElement> context) {
        return this.typeDoc(context, enumType, (f, doc) -> f.transform(b -> b.description(doc)));
    }

    public TraversalControl visitGraphQLEnumValueDefinition(GraphQLEnumValueDefinition enumValue, TraverserContext<GraphQLSchemaElement> context) {
        return this.fieldDoc(context, enumValue, enumValue.getDeprecationReason(), (f, doc) -> f.transform(b -> b.description(doc)), (f, reason) -> f.transform(b -> b.deprecationReason(reason)));
    }

    public TraversalControl visitGraphQLFieldDefinition(GraphQLFieldDefinition field, TraverserContext<GraphQLSchemaElement> context) {
        return this.fieldDoc(context, field, field.getDeprecationReason(), (f, doc) -> f.transform(b -> b.description(doc)), (f, reason) -> f.transform(b -> b.deprecate(reason)));
    }

    public TraversalControl visitGraphQLInputObjectField(GraphQLInputObjectField inputField, TraverserContext<GraphQLSchemaElement> context) {
        return this.fieldDoc(context, inputField, inputField.getDeprecationReason(), (f, doc) -> f.transform(b -> b.description(doc)), (f, reason) -> f.transform(b -> b.deprecate(reason)));
    }

    public TraversalControl visitGraphQLInputObjectType(GraphQLInputObjectType inputType, TraverserContext<GraphQLSchemaElement> context) {
        return this.typeDoc(context, inputType, (f, doc) -> f.transform(b -> b.description(doc)));
    }

    public TraversalControl visitGraphQLObjectType(GraphQLObjectType object, TraverserContext<GraphQLSchemaElement> context) {
        return this.typeDoc(context, object, (f, doc) -> f.transform(b -> b.description(doc)));
    }

    public TraversalControl visitGraphQLUnionType(GraphQLUnionType union, TraverserContext<GraphQLSchemaElement> context) {
        return this.typeDoc(context, union, (f, doc) -> f.transform(b -> b.description(doc)));
    }

    private <T extends GraphQLNamedSchemaElement> TraversalControl typeDoc(TraverserContext<GraphQLSchemaElement> context, T element, BiFunction<T, String, T> setDescription) {
        this.customDocumentation.typeDescription(element.getName(), element.getDescription()).map(doc -> (GraphQLNamedSchemaElement)setDescription.apply(element, (String)doc)).ifPresent(f -> this.changeNode(context, (GraphQLSchemaElement)f));
        return TraversalControl.CONTINUE;
    }

    private <T extends GraphQLNamedSchemaElement> TraversalControl fieldDoc(TraverserContext<GraphQLSchemaElement> context, T field, String originalDeprecatedReason, BiFunction<T, String, T> setDescription, BiFunction<T, String, T> setDeprecatedReason) {
        Object object = context.getParentNode();
        if (!(object instanceof GraphQLNamedSchemaElement)) {
            throw new IllegalArgumentException("The field does not have a named parent: " + String.valueOf(field));
        }
        GraphQLNamedSchemaElement parent = (GraphQLNamedSchemaElement)object;
        String fieldName = field.getName();
        String typeName = parent.getName();
        Optional<GraphQLNamedSchemaElement> withDescription = this.customDocumentation.fieldDescription(typeName, fieldName, field.getDescription()).map(doc -> (GraphQLNamedSchemaElement)setDescription.apply(field, (String)doc));
        Optional<GraphQLNamedSchemaElement> withDeprecated = this.customDocumentation.fieldDeprecatedReason(typeName, fieldName, originalDeprecatedReason).map(doc -> (GraphQLNamedSchemaElement)setDeprecatedReason.apply((Object)withDescription.orElse(field), (String)doc));
        withDeprecated.or(() -> withDescription).ifPresent(f -> this.changeNode(context, (GraphQLSchemaElement)f));
        return TraversalControl.CONTINUE;
    }
}

