/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.support.graphql.injectdoc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nullable;
import org.opentripplanner.apis.support.graphql.injectdoc.ApiDocumentationProfile;
import org.opentripplanner.framework.application.OtpAppException;
import org.opentripplanner.utils.text.TextVariablesSubstitution;

public class CustomDocumentation {
    private static final String APPEND_SUFFIX = ".append";
    private static final String DESCRIPTION_SUFFIX = ".description";
    private static final String DEPRECATED_SUFFIX = ".deprecated";
    private static final String DOC_PATH = "org/opentripplanner/ext/apis/transmodel/";
    private static final String FILE_NAME = "custom-documentation";
    private static final String FILE_EXTENSION = ".properties";
    private static final CustomDocumentation EMPTY = new CustomDocumentation(Map.of());
    private final Map<String, String> textMap;

    CustomDocumentation(Map<String, String> textMap) {
        this.textMap = textMap;
    }

    public static CustomDocumentation of(ApiDocumentationProfile profile) {
        if (profile == ApiDocumentationProfile.DEFAULT) {
            return EMPTY;
        }
        Map<String, String> map = CustomDocumentation.loadCustomDocumentationFromPropertiesFile(profile);
        return map.isEmpty() ? EMPTY : new CustomDocumentation(map);
    }

    public boolean isEmpty() {
        return this.textMap.isEmpty();
    }

    public Optional<String> typeDescription(String typeName, @Nullable String originalDoc) {
        return this.text(typeName, DESCRIPTION_SUFFIX, originalDoc);
    }

    public Optional<String> fieldDescription(String typeName, String fieldName, @Nullable String originalDoc) {
        return this.text(CustomDocumentation.key(typeName, fieldName), DESCRIPTION_SUFFIX, originalDoc);
    }

    public Optional<String> fieldDeprecatedReason(String typeName, String fieldName, @Nullable String originalDoc) {
        return this.text(CustomDocumentation.key(typeName, fieldName), DEPRECATED_SUFFIX, originalDoc);
    }

    private static String key(String typeName, String fieldName) {
        return typeName + "." + fieldName;
    }

    private Optional<String> text(String key, String suffix, @Nullable String originalText) {
        String k = key + suffix;
        return this.text(k).or(() -> this.appendText(k, originalText));
    }

    private Optional<String> text(String key) {
        return Optional.ofNullable(this.textMap.get(key));
    }

    private Optional<String> appendText(String key, @Nullable String originalText) {
        String value = this.textMap.get(key + APPEND_SUFFIX);
        if (value == null) {
            return Optional.empty();
        }
        return originalText == null ? Optional.of(value) : Optional.of(originalText + "\n\n" + value);
    }

    private static Map<String, String> loadCustomDocumentationFromPropertiesFile(ApiDocumentationProfile profile) {
        try {
            String resource = CustomDocumentation.resourceName(profile);
            InputStream input = ClassLoader.getSystemResourceAsStream(resource);
            if (input == null) {
                throw new OtpAppException("Resource not found: %s", resource);
            }
            Properties props = new Properties();
            props.load(new InputStreamReader(input, StandardCharsets.UTF_8));
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : props.stringPropertyNames()) {
                String value = props.getProperty(key);
                if (value == null) {
                    value = "";
                }
                map.put(key, value);
            }
            return TextVariablesSubstitution.insertVariables(map, varName -> CustomDocumentation.errorHandlerVariableSubstitution(varName, resource));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void errorHandlerVariableSubstitution(String name, String source) {
        throw new OtpAppException("Variable substitution failed for '${%s}' in %s.", name, source);
    }

    private static String resourceName(ApiDocumentationProfile profile) {
        return "org/opentripplanner/ext/apis/transmodel/custom-documentation-" + profile.name().toLowerCase() + FILE_EXTENSION;
    }
}

