/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.support;

import io.micrometer.core.instrument.Tag;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Collection;

public final class TracingUtils {
    private static final String UNKNOWN_VALUE = "__UNKNOWN__";

    public static Iterable<Tag> findTagsInHeaders(Collection<String> tracingHeaderTags, HttpHeaders headers) {
        return tracingHeaderTags.stream().map(header -> {
            String value = headers.getHeaderString(header);
            return Tag.of((String)header, (String)(value == null ? UNKNOWN_VALUE : value));
        }).toList();
    }

    public static Iterable<Tag> findTagsInHeadersOrQueryParameters(Collection<String> tracingTags, HttpHeaders headers, MultivaluedMap<String, String> queryParameters) {
        return tracingTags.stream().map(header -> {
            String headerValue = headers.getHeaderString(header);
            String queryParameterValue = (String)queryParameters.getFirst(header);
            if (headerValue != null) {
                return Tag.of((String)header, (String)headerValue);
            }
            if (queryParameterValue != null) {
                return Tag.of((String)header, (String)queryParameterValue);
            }
            return Tag.of((String)header, (String)UNKNOWN_VALUE);
        }).toList();
    }
}

