/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.support;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.io.HttpUtils;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.service.worldenvelope.model.WorldEnvelope;

public class TileJson
implements Serializable {
    public final String tilejson = "2.2.0";
    public final String scheme = "xyz";
    public final int minzoom;
    public final int maxzoom;
    public final String name = "OpenTripPlanner";
    public final String attribution;
    public final String[] tiles;
    public final double[] bounds;
    public final double[] center;

    public TileJson(String tileUrl, WorldEnvelope envelope, String attribution, int minZoom, int maxZoom) {
        this.attribution = attribution;
        this.tiles = new String[]{tileUrl};
        this.bounds = new double[]{envelope.lowerLeft().longitude(), envelope.lowerLeft().latitude(), envelope.upperRight().longitude(), envelope.upperRight().latitude()};
        WgsCoordinate c = envelope.center();
        this.center = new double[]{c.longitude(), c.latitude(), 9.0};
        this.minzoom = minZoom;
        this.maxzoom = maxZoom;
    }

    public TileJson(String tileUrl, WorldEnvelope envelope, Collection<FeedInfo> feedInfos, int minZoom, int maxZoom) {
        this(tileUrl, envelope, TileJson.attributionFromFeedInfo(feedInfos), minZoom, maxZoom);
    }

    public static String urlWithDefaultPath(UriInfo uri, HttpHeaders headers, List<String> layers, String ignoreRouterId, String path) {
        return "%s/otp/routers/%s/%s/%s/{z}/{x}/{y}.pbf".formatted(HttpUtils.getBaseAddress(uri, headers), ignoreRouterId, path, String.join((CharSequence)",", layers));
    }

    public static String urlFromOverriddenBasePath(UriInfo uri, HttpHeaders headers, String overridePath, List<String> layers) {
        String strippedPath = StringUtils.stripStart((String)overridePath, (String)"/");
        strippedPath = StringUtils.stripEnd((String)strippedPath, (String)"/");
        return "%s/%s/%s/{z}/{x}/{y}.pbf".formatted(HttpUtils.getBaseAddress(uri, headers), strippedPath, String.join((CharSequence)",", layers));
    }

    private static String attributionFromFeedInfo(Collection<FeedInfo> feedInfos) {
        return feedInfos.stream().map(feedInfo -> "<a href='%s'>%s</a>".formatted(feedInfo.getPublisherUrl(), feedInfo.getPublisherName())).distinct().collect(Collectors.joining(", "));
    }
}

