/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.apis.support;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.util.List;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;

public class SemanticHash {
    private SemanticHash() {
    }

    public static String forTripPattern(TripPattern tripPattern, Trip trip) {
        HashFunction murmur = Hashing.murmur3_32();
        BaseEncoding encoder = BaseEncoding.base64Url().omitPadding();
        StringBuilder sb = new StringBuilder(50);
        sb.append(encoder.encode(SemanticHash.forStopPattern(tripPattern, murmur).asBytes()));
        if (trip != null) {
            TripTimes tripTimes = tripPattern.getScheduledTimetable().getTripTimes(trip);
            if (tripTimes == null) {
                return null;
            }
            sb.append(':');
            sb.append(encoder.encode(SemanticHash.forTripTimes(tripTimes, murmur).asBytes()));
        }
        return sb.toString();
    }

    private static HashCode forStopPattern(TripPattern tripPattern, HashFunction hashFunction) {
        Hasher hasher = hashFunction.newHasher();
        List<StopLocation> stops = tripPattern.getStops();
        int size = stops.size();
        for (StopLocation stop : stops) {
            hasher.putLong((long)(stop.getLat() * 1000000.0));
            hasher.putLong((long)(stop.getLon() * 1000000.0));
        }
        for (int hop = 0; hop < size - 1; ++hop) {
            hasher.putInt(tripPattern.getBoardType(hop).ordinal());
            hasher.putInt(tripPattern.getAlightType(hop + 1).ordinal());
        }
        return hasher.hash();
    }

    private static HashCode forTripTimes(TripTimes tripTimes, HashFunction hashFunction) {
        Hasher hasher = hashFunction.newHasher();
        for (int hop = 0; hop < tripTimes.getNumStops() - 1; ++hop) {
            hasher.putInt(tripTimes.getScheduledDepartureTime(hop));
            hasher.putInt(tripTimes.getScheduledArrivalTime(hop + 1));
        }
        return hasher.hash();
    }
}

